/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

public class Tagged<T extends WritableComparable>
implements WritableComparable<Tagged> {
    protected byte tag = (byte)-1;
    protected T base;

    public Tagged(T b, byte t) {
        this.base = b;
        this.tag = t;
    }

    public Tagged() {
    }

    public byte getTag() {
        return this.tag;
    }

    public T getBaseObject() {
        return this.base;
    }

    public void setTag(byte t) {
        this.tag = t;
    }

    public void setBaseObject(T b) {
        this.base = b;
    }

    public void readFields(DataInput in) throws IOException {
        this.tag = in.readByte();
        this.base.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.tag);
        this.base.write(out);
    }

    public String toString() {
        return this.base.toString() + " ~~ tag: " + this.tag;
    }

    public int compareTo(Tagged other) {
        if (this.tag != other.tag) {
            return this.tag - other.tag;
        }
        return this.getBaseObject().compareTo(other.getBaseObject());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tagged)) {
            return false;
        }
        Tagged that = (Tagged)o;
        return this.tag == that.tag && this.getBaseObject().equals(that.getBaseObject());
    }

    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }
}

