/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import com.google.common.cache.Cache;
import java.security.AccessController;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.QpidPrincipal;
import org.apache.qpid.server.virtualhost.CacheProvider;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;

public class CacheFactory {
    public static <K, V> Cache<K, V> getCache(String cacheName, Cache<K, V> defaultCache) {
        VirtualHostPrincipal principal;
        Cache<K, V> cache = defaultCache;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && (principal = QpidPrincipal.getSingletonPrincipal(subject, true, VirtualHostPrincipal.class)) != null && principal.getVirtualHost() instanceof CacheProvider) {
            CacheProvider cacheProvider = (CacheProvider)((Object)principal.getVirtualHost());
            cache = cacheProvider.getNamedCache(cacheName);
        }
        return cache;
    }
}

