/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.preferences;

import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.model.preferences.Preference;
import org.apache.qpid.server.model.preferences.PreferenceFactory;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceRecordImpl;
import org.apache.qpid.server.store.preferences.PreferenceStore;

public class UserPreferencesImpl
implements UserPreferences {
    private static final Comparator<Preference> PREFERENCE_COMPARATOR = new Comparator<Preference>(){
        private final Ordering<Comparable> _ordering = Ordering.natural().nullsFirst();

        @Override
        public int compare(Preference o1, Preference o2) {
            int nameOrder = this._ordering.compare((Object)o1.getName(), (Object)o2.getName());
            if (nameOrder != 0) {
                return nameOrder;
            }
            int typeOrder = this._ordering.compare((Object)o1.getType(), (Object)o2.getType());
            if (typeOrder != 0) {
                return typeOrder;
            }
            return o1.getId().compareTo(o2.getId());
        }
    };
    private final Map<UUID, Preference> _preferences = new HashMap<UUID, Preference>();
    private final Map<String, List<Preference>> _preferencesByName = new HashMap<String, List<Preference>>();
    private final PreferenceStore _preferenceStore;
    private final TaskExecutor _executor;
    private final ConfiguredObject<?> _associatedObject;

    public UserPreferencesImpl(TaskExecutor executor, ConfiguredObject<?> associatedObject, PreferenceStore preferenceStore, Collection<Preference> preferences) {
        this._preferenceStore = preferenceStore;
        this._executor = executor;
        this._associatedObject = associatedObject;
        for (Preference preference : preferences) {
            this.addPreference(preference);
        }
    }

    @Override
    public ListenableFuture<Void> updateOrAppend(final Collection<Preference> preferences) {
        return this._executor.submit(new PreferencesTask<Void>("updateOrAppend", new Object[]{preferences}){

            @Override
            public Void doOperation() {
                UserPreferencesImpl.this.doUpdateOrAppend(preferences);
                return null;
            }
        });
    }

    private void doUpdateOrAppend(Collection<Preference> preferences) {
        Collection<Preference> augmentedPreferences = this.augmentForUpdate(preferences);
        this.validateNewPreferencesForUpdate(augmentedPreferences);
        HashSet<PreferenceRecord> preferenceRecords = new HashSet<PreferenceRecord>();
        for (Preference preference : augmentedPreferences) {
            preferenceRecords.add(PreferenceRecordImpl.fromPreference(preference));
        }
        this._preferenceStore.updateOrCreate(preferenceRecords);
        for (Preference preference : augmentedPreferences) {
            Preference oldPreference = this._preferences.get(preference.getId());
            if (oldPreference != null) {
                this._preferencesByName.get(oldPreference.getName()).remove(oldPreference);
            }
            this.addPreference(preference);
        }
    }

    @Override
    public ListenableFuture<Set<Preference>> getPreferences() {
        return this._executor.submit(new PreferencesTask<Set<Preference>>("getPreferences", new Object[0]){

            @Override
            public Set<Preference> doOperation() {
                return UserPreferencesImpl.this.doGetPreferences();
            }
        });
    }

    private Set<Preference> doGetPreferences() {
        Principal currentPrincipal = this.getMainPrincipalOrThrow();
        TreeSet<Preference> preferences = new TreeSet<Preference>(PREFERENCE_COMPARATOR);
        for (Preference preference : this._preferences.values()) {
            if (!GenericPrincipal.principalsEqual(currentPrincipal, preference.getOwner())) continue;
            preferences.add(preference);
        }
        return preferences;
    }

    @Override
    public ListenableFuture<Void> replace(final Collection<Preference> preferences) {
        return this._executor.submit(new PreferencesTask<Void>("replace", new Object[]{preferences}){

            @Override
            public Void doOperation() {
                UserPreferencesImpl.this.doReplaceByType(null, preferences);
                return null;
            }
        });
    }

    @Override
    public ListenableFuture<Void> replaceByType(final String type, final Collection<Preference> preferences) {
        return this._executor.submit(new PreferencesTask<Void>("replaceByType", new Object[]{type, preferences}){

            @Override
            public Void doOperation() {
                UserPreferencesImpl.this.doReplaceByType(type, preferences);
                return null;
            }
        });
    }

    private void doReplaceByType(String type, Collection<Preference> preferences) {
        Principal currentPrincipal = this.getMainPrincipalOrThrow();
        Collection<Preference> augmentedPreferences = this.augmentForReplace(preferences);
        this.validateNewPreferencesForReplaceByType(type, augmentedPreferences);
        HashSet<UUID> preferenceRecordsToRemove = new HashSet<UUID>();
        HashSet<PreferenceRecord> preferenceRecordsToAdd = new HashSet<PreferenceRecord>();
        for (Preference preference : this._preferences.values()) {
            if (!GenericPrincipal.principalsEqual(preference.getOwner(), currentPrincipal) || type != null && !Objects.equals(preference.getType(), type)) continue;
            preferenceRecordsToRemove.add(preference.getId());
        }
        for (Preference preference : augmentedPreferences) {
            preferenceRecordsToAdd.add(PreferenceRecordImpl.fromPreference(preference));
        }
        this._preferenceStore.replace(preferenceRecordsToRemove, preferenceRecordsToAdd);
        for (UUID id : preferenceRecordsToRemove) {
            Preference preference = this._preferences.remove(id);
            this._preferencesByName.get(preference.getName()).remove(preference);
        }
        for (Preference preference : augmentedPreferences) {
            this.addPreference(preference);
        }
    }

    @Override
    public ListenableFuture<Void> replaceByTypeAndName(final String type, final String name, final Preference newPreference) {
        return this._executor.submit(new PreferencesTask<Void>("replaceByTypeAndName", new Object[]{type, name, newPreference}){

            @Override
            public Void doOperation() {
                UserPreferencesImpl.this.doReplaceByTypeAndName(type, name, newPreference);
                return null;
            }
        });
    }

    private void doReplaceByTypeAndName(String type, String name, Preference newPreference) {
        Principal currentPrincipal = this.getMainPrincipalOrThrow();
        Preference augmentedPreference = newPreference == null ? null : this.augmentForReplace(Collections.singleton(newPreference)).iterator().next();
        this.validateNewPreferencesForReplaceByTypeAndName(type, name, augmentedPreference);
        UUID existingPreferenceId = null;
        Iterator<Preference> preferenceIterator = null;
        List<Preference> preferencesWithSameName = this._preferencesByName.get(name);
        if (preferencesWithSameName != null) {
            preferenceIterator = preferencesWithSameName.iterator();
            while (preferenceIterator.hasNext()) {
                Preference preference = preferenceIterator.next();
                if (!GenericPrincipal.principalsEqual(preference.getOwner(), currentPrincipal) || !Objects.equals(preference.getType(), type)) continue;
                existingPreferenceId = preference.getId();
                break;
            }
        }
        this._preferenceStore.replace(existingPreferenceId != null ? Set.of(existingPreferenceId) : List.of(), augmentedPreference == null ? List.of() : Set.of(PreferenceRecordImpl.fromPreference(augmentedPreference)));
        if (existingPreferenceId != null) {
            this._preferences.remove(existingPreferenceId);
            preferenceIterator.remove();
        }
        if (augmentedPreference != null) {
            this.addPreference(augmentedPreference);
        }
    }

    @Override
    public ListenableFuture<Void> delete(final String type, final String name, final UUID id) {
        return this._executor.submit(new PreferencesTask<Void>("delete", new Object[]{type, name, id}){

            @Override
            public Void doOperation() {
                UserPreferencesImpl.this.doDelete(type, name, id);
                return null;
            }
        });
    }

    private void doDelete(String type, String name, UUID id) {
        if (type == null && name != null) {
            throw new IllegalArgumentException("Cannot specify name without specifying type");
        }
        if (id != null) {
            Set<Preference> allPreferences = this.doGetPreferences();
            for (Preference preference : allPreferences) {
                if (!id.equals(preference.getId())) continue;
                if ((type == null || type.equals(preference.getType())) && (name == null || name.equals(preference.getName()))) {
                    this.doReplaceByTypeAndName(preference.getType(), preference.getName(), null);
                }
                break;
            }
        } else if (type != null && name != null) {
            this.doReplaceByTypeAndName(type, name, null);
        } else {
            this.doReplaceByType(type, Set.of());
        }
    }

    @Override
    public ListenableFuture<Set<Preference>> getVisiblePreferences() {
        return this._executor.submit(new PreferencesTask<Set<Preference>>("getVisiblePreferences", new Object[0]){

            @Override
            public Set<Preference> doOperation() {
                return UserPreferencesImpl.this.doGetVisiblePreferences();
            }
        });
    }

    private Set<Preference> doGetVisiblePreferences() {
        Set<Principal> currentPrincipals = this.getPrincipalsOrThrow();
        TreeSet<Preference> visiblePreferences = new TreeSet<Preference>(PREFERENCE_COMPARATOR);
        block0: for (Preference preference : this._preferences.values()) {
            if (GenericPrincipal.principalsContain(currentPrincipals, preference.getOwner())) {
                visiblePreferences.add(preference);
                continue;
            }
            Set<Principal> visibilityList = preference.getVisibilityList();
            if (visibilityList == null) continue;
            for (Principal principal : visibilityList) {
                if (!GenericPrincipal.principalsContain(currentPrincipals, principal)) continue;
                visiblePreferences.add(preference);
                continue block0;
            }
        }
        return visiblePreferences;
    }

    private void validateNewPreferencesForReplaceByType(String type, Collection<Preference> preferences) {
        if (type != null) {
            for (Preference preference : preferences) {
                if (Objects.equals(preference.getType(), type)) continue;
                throw new IllegalArgumentException(String.format("Replacing preferences of type '%s' with preferences of different type '%s'", type, preference.getType()));
            }
        }
        this.checkForValidVisibilityLists(preferences);
        this.checkForConflictWithinCollection(preferences);
        this.ensureSameTypeAndOwnerForExistingPreferences(preferences);
    }

    private void validateNewPreferencesForReplaceByTypeAndName(String type, String name, Preference newPreference) {
        if (newPreference == null) {
            return;
        }
        if (!Objects.equals(newPreference.getType(), type)) {
            throw new IllegalArgumentException(String.format("Replacing preference of type '%s' with preference of different type '%s'", type, newPreference.getType()));
        }
        if (!Objects.equals(newPreference.getName(), name)) {
            throw new IllegalArgumentException(String.format("Replacing preference with name '%s' with preference of different name '%s'", name, newPreference.getName()));
        }
        this.checkForValidVisibilityLists(Collections.singleton(newPreference));
        this.ensureSameTypeAndOwnerForExistingPreferences(Collections.singleton(newPreference));
    }

    private void validateNewPreferencesForUpdate(Collection<Preference> preferences) {
        this.checkForValidVisibilityLists(preferences);
        this.checkForConflictWithExisting(preferences);
        this.checkForConflictWithinCollection(preferences);
    }

    private Collection<Preference> augmentForUpdate(Collection<Preference> preferences) {
        HashSet<Preference> augmentedPreferences = new HashSet<Preference>(preferences.size());
        for (Preference preference : preferences) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(preference.getAttributes());
            AuthenticatedPrincipal currentUser = AuthenticatedPrincipal.getCurrentUser();
            Date currentTime = new Date();
            attributes.put("lastUpdatedDate", currentTime);
            attributes.put("createdDate", currentTime);
            attributes.put("owner", currentUser);
            if (preference.getId() == null) {
                attributes.put("id", UUID.randomUUID());
            } else {
                Preference existingPreference = this._preferences.get(preference.getId());
                if (existingPreference != null) {
                    attributes.put("createdDate", existingPreference.getCreatedDate());
                }
            }
            augmentedPreferences.add(PreferenceFactory.fromAttributes(preference.getAssociatedObject(), attributes));
        }
        return augmentedPreferences;
    }

    private Collection<Preference> augmentForReplace(Collection<Preference> preferences) {
        HashSet<Preference> augmentedPreferences = new HashSet<Preference>(preferences.size());
        for (Preference preference : preferences) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(preference.getAttributes());
            AuthenticatedPrincipal currentUser = AuthenticatedPrincipal.getCurrentUser();
            Date currentTime = new Date();
            attributes.put("lastUpdatedDate", currentTime);
            attributes.put("createdDate", currentTime);
            attributes.put("owner", currentUser);
            if (preference.getId() == null) {
                attributes.put("id", UUID.randomUUID());
            }
            augmentedPreferences.add(PreferenceFactory.fromAttributes(preference.getAssociatedObject(), attributes));
        }
        return augmentedPreferences;
    }

    private void checkForValidVisibilityLists(Collection<Preference> preferences) {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            throw new IllegalStateException("Current thread does not have a user");
        }
        Set<Principal> principals = currentSubject.getPrincipals();
        for (Preference preference : preferences) {
            for (Principal visibilityPrincipal : preference.getVisibilityList()) {
                if (GenericPrincipal.principalsContain(principals, visibilityPrincipal)) continue;
                String errorMessage = String.format("Invalid visibilityList, this user does not hold principal '%s'", visibilityPrincipal);
                throw new IllegalArgumentException(errorMessage);
            }
        }
    }

    private void ensureSameTypeAndOwnerForExistingPreferences(Collection<Preference> preferences) {
        Principal currentPrincipal = this.getMainPrincipalOrThrow();
        for (Preference preference : preferences) {
            if (preference.getId() == null || !this._preferences.containsKey(preference.getId())) continue;
            Preference existingPreference = this._preferences.get(preference.getId());
            if (preference.getType().equals(existingPreference.getType()) && GenericPrincipal.principalsEqual(existingPreference.getOwner(), currentPrincipal)) continue;
            throw new IllegalArgumentException(String.format("Preference Id '%s' already exists", preference.getId()));
        }
    }

    private void checkForConflictWithExisting(Collection<Preference> preferences) {
        this.ensureSameTypeAndOwnerForExistingPreferences(preferences);
        for (Preference preference : preferences) {
            List<Preference> preferencesWithSameName = this._preferencesByName.get(preference.getName());
            if (preferencesWithSameName == null) continue;
            for (Preference preferenceWithSameName : preferencesWithSameName) {
                if (!GenericPrincipal.principalsEqual(preferenceWithSameName.getOwner(), preference.getOwner()) || !Objects.equals(preferenceWithSameName.getType(), preference.getType()) || Objects.equals(preferenceWithSameName.getId(), preference.getId())) continue;
                throw new IllegalArgumentException(String.format("Preference '%s' of type '%s' already exists", preference.getName(), preference.getType()));
            }
        }
    }

    private void checkForConflictWithinCollection(Collection<Preference> preferences) {
        HashMap<UUID, Preference> checkedPreferences = new HashMap<UUID, Preference>(preferences.size());
        HashMap checkedPreferencesByName = new HashMap(preferences.size());
        for (Preference preference : preferences) {
            if (checkedPreferences.containsKey(preference.getId())) {
                throw new IllegalArgumentException(String.format("Duplicate Id '%s' in update set", preference.getId().toString()));
            }
            List checkedPreferencesWithSameName = (List)checkedPreferencesByName.get(preference.getName());
            if (checkedPreferencesWithSameName != null) {
                for (Preference preferenceWithSameName : checkedPreferencesWithSameName) {
                    if (!Objects.equals(preferenceWithSameName.getType(), preference.getType()) || Objects.equals(preferenceWithSameName.getId(), preference.getId())) continue;
                    throw new IllegalArgumentException(String.format("Duplicate preference name '%s' of type '%s' in update set", preference.getName(), preference.getType()));
                }
            } else {
                checkedPreferencesByName.put(preference.getName(), new ArrayList());
            }
            checkedPreferences.put(preference.getId(), preference);
            ((List)checkedPreferencesByName.get(preference.getName())).add(preference);
        }
    }

    private Principal getMainPrincipalOrThrow() throws SecurityException {
        AuthenticatedPrincipal currentPrincipal = AuthenticatedPrincipal.getCurrentUser();
        if (currentPrincipal == null) {
            throw new SecurityException("Current thread does not have a user");
        }
        return currentPrincipal;
    }

    private Set<Principal> getPrincipalsOrThrow() throws SecurityException {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            throw new SecurityException("Current thread does not have a user");
        }
        Set<Principal> currentPrincipals = currentSubject.getPrincipals();
        if (currentPrincipals == null || currentPrincipals.isEmpty()) {
            throw new SecurityException("Current thread does not have a user");
        }
        return currentPrincipals;
    }

    private void addPreference(Preference preference) {
        this._preferences.put(preference.getId(), preference);
        if (!this._preferencesByName.containsKey(preference.getName())) {
            this._preferencesByName.put(preference.getName(), new ArrayList());
        }
        this._preferencesByName.get(preference.getName()).add(preference);
    }

    private abstract class PreferencesTask<T>
    implements Task<T, RuntimeException> {
        private final Subject _subject;
        private final String _action;
        private final Object[] _arguments;
        private String _argumentString;

        private PreferencesTask(String action, Object ... arguments) {
            this._action = action;
            this._arguments = arguments;
            this._subject = Subject.getSubject(AccessController.getContext());
        }

        @Override
        public T execute() throws RuntimeException {
            return (T)Subject.doAs(this._subject, this::doOperation);
        }

        protected abstract T doOperation();

        @Override
        public String getObject() {
            return UserPreferencesImpl.this._associatedObject.getName();
        }

        @Override
        public String getAction() {
            return this._action;
        }

        @Override
        public String getArguments() {
            if (this._argumentString == null && this._arguments != null) {
                this._argumentString = this._arguments.length == 1 ? String.valueOf(this._arguments[0]) : Arrays.toString(this._arguments);
            }
            return this._argumentString;
        }
    }
}

