/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.ManagementModeStoreHandler;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.CompositeStartupMessageLogger;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.MessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ContainerType;
import org.apache.qpid.server.model.DynamicModel;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.SystemConfigBootstrapModel;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordConverter;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferenceStoreFactoryService;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.urlstreamhandler.classpath.Handler;

public abstract class AbstractSystemConfig<X extends SystemConfig<X>>
extends AbstractConfiguredObject<X>
implements SystemConfig<X>,
DynamicModel {
    private static final UUID SYSTEM_ID = new UUID(0L, 0L);
    private final Principal _systemPrincipal;
    private final EventLogger _eventLogger;
    private volatile DurableConfigurationStore _configurationStore;
    private Runnable _onContainerResolveTask;
    private Runnable _onContainerCloseTask;
    @ManagedAttributeField
    private boolean _managementMode;
    @ManagedAttributeField
    private int _managementModeHttpPortOverride;
    @ManagedAttributeField
    private boolean _managementModeQuiesceVirtualHosts;
    @ManagedAttributeField
    private String _managementModePassword;
    @ManagedAttributeField
    private String _initialConfigurationLocation;
    @ManagedAttributeField
    private String _initialSystemPropertiesLocation;
    @ManagedAttributeField
    private boolean _startupLoggedToSystemOut;
    @ManagedAttributeField
    private PreferenceStoreAttributes _preferenceStoreAttributes;
    @ManagedAttributeField
    private String _defaultContainerType;

    public AbstractSystemConfig(TaskExecutor taskExecutor, EventLogger eventLogger, Principal systemPrincipal, Map<String, Object> attributes) {
        super(null, AbstractSystemConfig.updateAttributes(attributes), taskExecutor, SystemConfigBootstrapModel.getInstance());
        this._eventLogger = eventLogger;
        this._systemPrincipal = systemPrincipal;
        this.getTaskExecutor().start();
    }

    private static Map<String, Object> updateAttributes(Map<String, Object> attributes) {
        attributes = new HashMap<String, Object>(attributes);
        attributes.put("name", "System");
        attributes.put("id", SYSTEM_ID);
        return attributes;
    }

    @Override
    protected void setState(State desiredState) {
        throw new IllegalArgumentException("Cannot change the state of the SystemContext object");
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    protected ListenableFuture<Void> onClose() {
        TaskExecutor taskExecutor = this.getTaskExecutor();
        try {
            if (taskExecutor != null) {
                taskExecutor.stop();
            }
            if (this._configurationStore != null) {
                this._configurationStore.closeConfigurationStore();
            }
        }
        finally {
            if (taskExecutor != null) {
                taskExecutor.stopImmediately();
            }
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public final <T extends Container<? extends T>> T getContainer(Class<T> clazz) {
        Collection<T> children = this.getChildren(clazz);
        if (children == null || children.isEmpty()) {
            return null;
        }
        if (children.size() != 1) {
            throw new IllegalConfigurationException("More than one " + clazz.getSimpleName() + " has been registered in a single context");
        }
        return (T)((Container)children.iterator().next());
    }

    @Override
    public final Container<?> getContainer() {
        Collection<Class<? extends ConfiguredObject>> containerTypes = this.getModel().getChildTypes(SystemConfig.class);
        Class<? extends ConfiguredObject> containerClass = null;
        for (Class<? extends ConfiguredObject> clazz : containerTypes) {
            if (!Container.class.isAssignableFrom(clazz)) continue;
            if (containerClass == null) {
                containerClass = clazz;
                continue;
            }
            throw new IllegalArgumentException("Model has more than one child Container class beneath SystemConfig");
        }
        if (containerClass == null) {
            throw new IllegalArgumentException("Model has no child Container class beneath SystemConfig");
        }
        return this.getContainer(containerClass);
    }

    @Override
    protected void onOpen() {
        this._configurationStore = this.createStoreObject();
        if (this.isManagementMode()) {
            this._configurationStore = new ManagementModeStoreHandler(this._configurationStore, this);
        }
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.STOPPED)
    protected ListenableFuture<Void> doStop() {
        return this.doAfter(this.getContainer().closeAsync(), () -> {
            this._configurationStore.closeConfigurationStore();
            AbstractSystemConfig.super.setState(State.STOPPED);
        });
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.STOPPED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        return this.doAfter(this.makeActive(), () -> AbstractSystemConfig.super.setState(State.ACTIVE));
    }

    protected ListenableFuture<Void> makeActive() {
        final EventLogger eventLogger = this._eventLogger;
        final EventLogger startupLogger = this.initiateStartupLogging();
        try {
            final Container<?> container = this.initiateStoreAndRecovery();
            container.setEventLogger(startupLogger);
            final SettableFuture returnVal = SettableFuture.create();
            AbstractSystemConfig.addFutureCallback(container.openAsync(), new FutureCallback(){

                public void onSuccess(Object result) {
                    State state = container.getState();
                    if (state == State.ACTIVE) {
                        startupLogger.message(BrokerMessages.READY());
                        container.setEventLogger(eventLogger);
                        returnVal.set(null);
                    } else {
                        returnVal.setException((Throwable)new ServerScopedRuntimeException("Broker failed reach ACTIVE state (state is " + state + ")"));
                    }
                }

                public void onFailure(Throwable t) {
                    returnVal.setException(t);
                }
            }, this.getTaskExecutor());
            return returnVal;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Container<?> initiateStoreAndRecovery() throws IOException {
        QpidServiceLoader loader;
        ContainerType containerType;
        ConfiguredObjectRecord[] initialRecords = this.convertToConfigurationRecords(this.getInitialConfigurationLocation());
        DurableConfigurationStore store = this.getConfigurationStore();
        store.init(this);
        store.upgradeStoreStructure();
        ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>();
        boolean isNew = store.openConfigurationStore(records::add, initialRecords);
        String containerTypeName = this.getDefaultContainerType();
        for (ConfiguredObjectRecord record : records) {
            if (record.getParents() == null || record.getParents().size() != 1 || !this.getId().equals(record.getParents().get(SystemConfig.class.getSimpleName()))) continue;
            containerTypeName = record.getType();
            break;
        }
        if ((containerType = (loader = new QpidServiceLoader()).getInstancesByType(ContainerType.class).get(containerTypeName)) != null) {
            if (containerType.getModel() != this.getModel()) {
                this.updateModel(containerType.getModel());
            }
        } else {
            throw new IllegalConfigurationException("Unknown container type '" + containerTypeName + "'");
        }
        containerType.getRecoverer(this).upgradeAndRecover(records);
        Class categoryClass = containerType.getCategoryClass();
        return this.getContainer(categoryClass);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    protected ListenableFuture<Void> startQuiesced() {
        EventLogger startupLogger = this.initiateStartupLogging();
        try {
            Container<?> container = this.initiateStoreAndRecovery();
            container.setEventLogger(startupLogger);
            return Futures.immediateFuture(null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private EventLogger initiateStartupLogging() {
        EventLogger startupLogger;
        EventLogger eventLogger = this._eventLogger;
        if (this.isStartupLoggedToSystemOut()) {
            MessageLogger[] messageLoggers = new MessageLogger[]{new SystemOutMessageLogger(), eventLogger.getMessageLogger()};
            CompositeStartupMessageLogger startupMessageLogger = new CompositeStartupMessageLogger(messageLoggers);
            startupLogger = new EventLogger(startupMessageLogger);
        } else {
            startupLogger = eventLogger;
        }
        return startupLogger;
    }

    @Override
    protected final boolean rethrowRuntimeExceptionsOnOpen() {
        return true;
    }

    protected abstract DurableConfigurationStore createStoreObject();

    @Override
    public DurableConfigurationStore getConfigurationStore() {
        return this._configurationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredObjectRecord[] convertToConfigurationRecords(String initialConfigurationLocation) throws IOException {
        InputStreamReader reader;
        ConfiguredObjectRecordConverter converter = new ConfiguredObjectRecordConverter(this.getModel());
        try {
            URL url = new URL(initialConfigurationLocation);
            reader = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException e) {
            reader = new FileReader(initialConfigurationLocation);
        }
        try {
            Collection<ConfiguredObjectRecord> records = converter.readFromJson(null, this, reader);
            ConfiguredObjectRecord[] configuredObjectRecordArray = records.toArray(new ConfiguredObjectRecord[records.size()]);
            return configuredObjectRecordArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    @Override
    public String getDefaultContainerType() {
        return this._defaultContainerType;
    }

    @Override
    public boolean isManagementMode() {
        return this._managementMode;
    }

    @Override
    public int getManagementModeHttpPortOverride() {
        return this._managementModeHttpPortOverride;
    }

    @Override
    public boolean isManagementModeQuiesceVirtualHosts() {
        return this._managementModeQuiesceVirtualHosts;
    }

    @Override
    public String getManagementModePassword() {
        return this._managementModePassword;
    }

    @Override
    public String getInitialConfigurationLocation() {
        return this._initialConfigurationLocation;
    }

    @Override
    public String getInitialSystemPropertiesLocation() {
        return this._initialSystemPropertiesLocation;
    }

    @Override
    public boolean isStartupLoggedToSystemOut() {
        return this._startupLoggedToSystemOut;
    }

    @Override
    public PreferenceStoreAttributes getPreferenceStoreAttributes() {
        return this._preferenceStoreAttributes;
    }

    @Override
    public PreferenceStore createPreferenceStore() {
        Map<String, Object> attributes;
        String preferenceStoreType;
        PreferenceStoreAttributes preferenceStoreAttributes = this.getPreferenceStoreAttributes();
        Map<String, PreferenceStoreFactoryService> preferenceStoreFactories = new QpidServiceLoader().getInstancesByType(PreferenceStoreFactoryService.class);
        if (preferenceStoreAttributes == null) {
            preferenceStoreType = "Noop";
            attributes = Map.of();
        } else {
            preferenceStoreType = preferenceStoreAttributes.getType();
            attributes = preferenceStoreAttributes.getAttributes();
        }
        PreferenceStoreFactoryService preferenceStoreFactory = preferenceStoreFactories.get(preferenceStoreType);
        return preferenceStoreFactory.createInstance(this, attributes);
    }

    @Override
    protected final Principal getSystemPrincipal() {
        return this._systemPrincipal;
    }

    @Override
    public Runnable getOnContainerResolveTask() {
        return this._onContainerResolveTask;
    }

    @Override
    public void setOnContainerResolveTask(Runnable onContainerResolveTask) {
        this._onContainerResolveTask = onContainerResolveTask;
    }

    @Override
    public Runnable getOnContainerCloseTask() {
        return this._onContainerCloseTask;
    }

    @Override
    public void setOnContainerCloseTask(Runnable onContainerCloseTask) {
        this._onContainerCloseTask = onContainerCloseTask;
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(BrokerMessages.OPERATION(operation));
    }

    public static String getDefaultValue(String attrName) {
        Model model = SystemConfigBootstrapModel.getInstance();
        ConfiguredObjectTypeRegistry typeRegistry = model.getTypeRegistry();
        ConfiguredObjectAttribute<?, ?> attr = typeRegistry.getAttributeTypes(SystemConfig.class).get(attrName);
        if (attr instanceof ConfiguredSettableAttribute) {
            return AbstractSystemConfig.interpolate(model, ((ConfiguredSettableAttribute)attr).defaultValue());
        }
        return null;
    }

    static {
        Handler.register();
    }
}

