/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AMQShortStringEncoding;
import org.apache.qpid.server.store.berkeleydb.FieldTableEncoding;
import org.apache.qpid.server.store.berkeleydb.upgrade.AbstractStoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.CursorOperation;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseRunnable;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseTemplate;
import org.apache.qpid.server.store.berkeleydb.upgrade.MapJsonSerializer;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeFrom5To6
extends AbstractStoreUpgrade {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeFrom5To6.class);
    private static final Set<String> DEFAULT_EXCHANGES_SET = Set.of("", "amq.fanout", "amq.match", "amq.topic", "amq.direct");
    private static final String ARGUMENTS = "arguments";
    private static final boolean MOVE_NON_EXCLUSIVE_QUEUE_OWNER_TO_DESCRIPTION = Boolean.parseBoolean(System.getProperty("qpid.move_non_exclusive_queue_owner_to_description", Boolean.TRUE.toString()));
    static final String OLD_CONTENT_DB_NAME = "messageContentDb_v5";
    static final String NEW_CONTENT_DB_NAME = "MESSAGE_CONTENT";
    static final String NEW_METADATA_DB_NAME = "MESSAGE_METADATA";
    static final String OLD_META_DATA_DB_NAME = "messageMetaDataDb_v5";
    static final String OLD_EXCHANGE_DB_NAME = "exchangeDb_v5";
    static final String OLD_QUEUE_DB_NAME = "queueDb_v5";
    static final String OLD_DELIVERY_DB_NAME = "deliveryDb_v5";
    static final String OLD_QUEUE_BINDINGS_DB_NAME = "queueBindingsDb_v5";
    static final String OLD_XID_DB_NAME = "xids_v5";
    static final String NEW_XID_DB_NAME = "XIDS";
    static final String CONFIGURED_OBJECTS_DB_NAME = "CONFIGURED_OBJECTS";
    static final String NEW_DELIVERY_DB_NAME = "QUEUE_ENTRIES";
    static final String NEW_BRIDGES_DB_NAME = "BRIDGES";
    static final String NEW_LINKS_DB_NAME = "LINKS";
    static final String OLD_BRIDGES_DB_NAME = "bridges_v5";
    static final String OLD_LINKS_DB_NAME = "links_v5";
    private final MapJsonSerializer _serializer = new MapJsonSerializer();

    @Override
    public void performUpgrade(Environment environment, UpgradeInteractionHandler handler, ConfiguredObject<?> parent) {
        this.reportStarting(environment, 5);
        this.upgradeMessages(environment, handler);
        this.upgradeConfiguredObjectsAndDependencies(environment, handler, parent.getName());
        this.renameDatabases(environment, null);
        this.reportFinished(environment, 6);
    }

    private void upgradeConfiguredObjectsAndDependencies(Environment environment, UpgradeInteractionHandler handler, String virtualHostName) {
        Transaction transaction = null;
        transaction = environment.beginTransaction(null, null);
        this.upgradeConfiguredObjects(environment, handler, transaction, virtualHostName);
        this.upgradeQueueEntries(environment, transaction, virtualHostName);
        this.upgradeXidEntries(environment, transaction, virtualHostName);
        transaction.commit();
    }

    private void upgradeMessages(Environment environment, UpgradeInteractionHandler handler) {
        Transaction transaction = null;
        transaction = environment.beginTransaction(null, null);
        this.upgradeMessages(environment, handler, transaction);
        transaction.commit();
    }

    private void renameDatabases(Environment environment, Transaction transaction) {
        List databases = environment.getDatabaseNames();
        String[] oldDatabases = new String[]{OLD_META_DATA_DB_NAME, OLD_BRIDGES_DB_NAME, OLD_LINKS_DB_NAME};
        String[] newDatabases = new String[]{NEW_METADATA_DB_NAME, NEW_BRIDGES_DB_NAME, NEW_LINKS_DB_NAME};
        for (int i = 0; i < oldDatabases.length; ++i) {
            String oldName = oldDatabases[i];
            String newName = newDatabases[i];
            if (!databases.contains(oldName)) continue;
            LOGGER.info("Renaming " + oldName + " into " + newName);
            environment.renameDatabase(transaction, oldName, newName);
        }
    }

    private void upgradeMessages(Environment environment, final UpgradeInteractionHandler handler, Transaction transaction) {
        LOGGER.info("Message Contents");
        if (environment.getDatabaseNames().contains(OLD_CONTENT_DB_NAME)) {
            DatabaseRunnable contentOperation = (oldContentDatabase, newContentDatabase, contentTransaction) -> {
                CursorOperation metaDataDatabaseOperation = new CursorOperation(){

                    @Override
                    public void processEntry(Database metadataDatabase, Database notUsed, Transaction metaDataTransaction, DatabaseEntry key, DatabaseEntry value) {
                        long messageId = LongBinding.entryToLong((DatabaseEntry)key);
                        UpgradeFrom5To6.this.upgradeMessage(messageId, oldContentDatabase, newContentDatabase, handler, metaDataTransaction, metadataDatabase);
                    }
                };
                new DatabaseTemplate(environment, OLD_META_DATA_DB_NAME, contentTransaction).run(metaDataDatabaseOperation);
                LOGGER.info(metaDataDatabaseOperation.getRowCount() + " Message Content Entries");
            };
            new DatabaseTemplate(environment, OLD_CONTENT_DB_NAME, NEW_CONTENT_DB_NAME, transaction).run(contentOperation);
            environment.removeDatabase(transaction, OLD_CONTENT_DB_NAME);
        }
    }

    private void upgradeMessage(long messageId, Database oldDatabase, Database newDatabase, UpgradeInteractionHandler handler, Transaction txn, Database oldMetadataDatabase) {
        int offset;
        Map.Entry<Integer, byte[]> entry2;
        SortedMap<Integer, byte[]> messageData = this.getMessageData(messageId, oldDatabase);
        byte[] consolidatedData = new byte[]{};
        for (Map.Entry<Integer, byte[]> entry2 : messageData.entrySet()) {
            offset = entry2.getKey();
            if (offset != consolidatedData.length) {
                String message = offset < consolidatedData.length ? "Missing data in message id " + messageId + " between offset " + consolidatedData.length + " and " + offset + ". " : "Duplicate data in message id " + messageId + " between offset " + offset + " and " + consolidatedData.length + ". ";
                UpgradeInteractionResponse action = handler.requireResponse(message + "Do you wish do recover as much of this message as possible (answering NO will delete the message)?", UpgradeInteractionResponse.ABORT, UpgradeInteractionResponse.YES, UpgradeInteractionResponse.NO, UpgradeInteractionResponse.ABORT);
                switch (action) {
                    case YES: {
                        byte[] oldData = consolidatedData;
                        consolidatedData = new byte[offset];
                        System.arraycopy(oldData, 0, consolidatedData, 0, Math.min(oldData.length, consolidatedData.length));
                        break;
                    }
                    case NO: {
                        DatabaseEntry key = new DatabaseEntry();
                        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
                        oldMetadataDatabase.delete(txn, key);
                        return;
                    }
                    case ABORT: {
                        LOGGER.error(message);
                        throw new StoreException("Unable to upgrade message " + messageId);
                    }
                }
            }
            byte[] data = new byte[consolidatedData.length + ((byte[])entry2.getValue()).length];
            System.arraycopy(consolidatedData, 0, data, 0, consolidatedData.length);
            System.arraycopy(entry2.getValue(), 0, data, offset, ((byte[])entry2.getValue()).length);
            consolidatedData = data;
        }
        CompoundKeyBinding binding = new CompoundKeyBinding();
        entry2 = messageData.keySet().iterator();
        while (entry2.hasNext()) {
            offset = (Integer)entry2.next();
            DatabaseEntry key = new DatabaseEntry();
            binding.objectToEntry(new CompoundKey(messageId, offset), key);
            oldDatabase.delete(txn, key);
        }
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        NewDataBinding dataBinding = new NewDataBinding();
        DatabaseEntry value = new DatabaseEntry();
        dataBinding.objectToEntry(consolidatedData, value);
        this.put(newDatabase, txn, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<Integer, byte[]> getMessageData(long messageId, Database oldDatabase) {
        TreeMap<Integer, byte[]> data = new TreeMap<Integer, byte[]>();
        try (Cursor cursor = oldDatabase.openCursor(null, CursorConfig.READ_COMMITTED);){
            DatabaseEntry contentKeyEntry = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            CompoundKeyBinding binding = new CompoundKeyBinding();
            binding.objectToEntry(new CompoundKey(messageId, 0), contentKeyEntry);
            OperationStatus status = cursor.getSearchKeyRange(contentKeyEntry, value, LockMode.DEFAULT);
            OldDataBinding dataBinding = new OldDataBinding();
            while (status == OperationStatus.SUCCESS) {
                CompoundKey compoundKey = (CompoundKey)binding.entryToObject(contentKeyEntry);
                long id = compoundKey.getMessageId();
                if (id != messageId) {
                    break;
                }
                int offsetInMessage = compoundKey.getOffset();
                OldDataValue dataValue = (OldDataValue)dataBinding.entryToObject(value);
                data.put(offsetInMessage, dataValue.getData());
                status = cursor.getNext(contentKeyEntry, value, LockMode.DEFAULT);
            }
        }
        return data;
    }

    private void upgradeConfiguredObjects(Environment environment, UpgradeInteractionHandler handler, Transaction transaction, String virtualHostName) {
        this.upgradeQueues(environment, transaction, virtualHostName);
        this.upgradeExchanges(environment, transaction, virtualHostName);
        this.upgradeQueueBindings(environment, transaction, handler, virtualHostName);
    }

    private void upgradeXidEntries(Environment environment, Transaction transaction, final String virtualHostName) {
        if (environment.getDatabaseNames().contains(OLD_XID_DB_NAME)) {
            LOGGER.info("Xid Records");
            final OldPreparedTransactionBinding oldTransactionBinding = new OldPreparedTransactionBinding();
            final NewPreparedTransactionBinding newTransactionBinding = new NewPreparedTransactionBinding();
            CursorOperation xidEntriesCursor = new CursorOperation(){

                @Override
                public void processEntry(Database oldXidDatabase, Database newXidDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    UUID id;
                    int i;
                    OldPreparedTransaction oldPreparedTransaction = (OldPreparedTransaction)oldTransactionBinding.entryToObject(value);
                    OldRecordImpl[] oldDequeues = oldPreparedTransaction.getDequeues();
                    OldRecordImpl[] oldEnqueues = oldPreparedTransaction.getEnqueues();
                    NewRecordImpl[] newEnqueues = null;
                    NewRecordImpl[] newDequeues = null;
                    if (oldDequeues != null) {
                        newDequeues = new NewRecordImpl[oldDequeues.length];
                        for (i = 0; i < newDequeues.length; ++i) {
                            OldRecordImpl dequeue = oldDequeues[i];
                            id = UUIDGenerator.generateQueueUUID((String)dequeue.getQueueName(), (String)virtualHostName);
                            newDequeues[i] = new NewRecordImpl(id, dequeue.getMessageNumber());
                        }
                    }
                    if (oldEnqueues != null) {
                        newEnqueues = new NewRecordImpl[oldEnqueues.length];
                        for (i = 0; i < newEnqueues.length; ++i) {
                            OldRecordImpl enqueue = oldEnqueues[i];
                            id = UUIDGenerator.generateQueueUUID((String)enqueue.getQueueName(), (String)virtualHostName);
                            newEnqueues[i] = new NewRecordImpl(id, enqueue.getMessageNumber());
                        }
                    }
                    NewPreparedTransaction newPreparedTransaction = new NewPreparedTransaction(newEnqueues, newDequeues);
                    DatabaseEntry newValue = new DatabaseEntry();
                    newTransactionBinding.objectToEntry(newPreparedTransaction, newValue);
                    UpgradeFrom5To6.this.put(newXidDatabase, transaction, key, newValue);
                }
            };
            new DatabaseTemplate(environment, OLD_XID_DB_NAME, NEW_XID_DB_NAME, transaction).run(xidEntriesCursor);
            environment.removeDatabase(transaction, OLD_XID_DB_NAME);
            LOGGER.info(xidEntriesCursor.getRowCount() + " Xid Entries");
        }
    }

    private void upgradeQueueEntries(Environment environment, Transaction transaction, final String virtualHostName) {
        LOGGER.info("Queue Delivery Records");
        if (environment.getDatabaseNames().contains(OLD_DELIVERY_DB_NAME)) {
            final OldQueueEntryBinding oldBinding = new OldQueueEntryBinding();
            final NewQueueEntryBinding newBinding = new NewQueueEntryBinding();
            CursorOperation queueEntriesCursor = new CursorOperation(){

                @Override
                public void processEntry(Database oldDeliveryDatabase, Database newDeliveryDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    OldQueueEntryKey oldEntryRecord = (OldQueueEntryKey)oldBinding.entryToObject(key);
                    UUID queueId = UUIDGenerator.generateQueueUUID((String)oldEntryRecord.getQueueName().toString(), (String)virtualHostName);
                    NewQueueEntryKey newEntryRecord = new NewQueueEntryKey(queueId, oldEntryRecord.getMessageId());
                    DatabaseEntry newKey = new DatabaseEntry();
                    newBinding.objectToEntry(newEntryRecord, newKey);
                    UpgradeFrom5To6.this.put(newDeliveryDatabase, transaction, newKey, value);
                }
            };
            new DatabaseTemplate(environment, OLD_DELIVERY_DB_NAME, NEW_DELIVERY_DB_NAME, transaction).run(queueEntriesCursor);
            environment.removeDatabase(transaction, OLD_DELIVERY_DB_NAME);
            LOGGER.info(queueEntriesCursor.getRowCount() + " Queue Delivery Record Entries");
        }
    }

    private void upgradeQueueBindings(Environment environment, Transaction transaction, UpgradeInteractionHandler handler, final String virtualHostName) {
        LOGGER.info("Queue Bindings");
        if (environment.getDatabaseNames().contains(OLD_QUEUE_BINDINGS_DB_NAME)) {
            final QueueBindingBinding binding = new QueueBindingBinding();
            CursorOperation bindingCursor = new CursorOperation(){

                @Override
                public void processEntry(Database exchangeDatabase, Database configuredObjectsDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    BindingRecord bindingRecord = (BindingRecord)binding.entryToObject(key);
                    String exchangeName = bindingRecord.getExchangeName() == null ? "" : bindingRecord.getExchangeName().toString();
                    String queueName = bindingRecord.getQueueName().toString();
                    String routingKey = bindingRecord.getRoutingKey().toString();
                    FieldTable arguments = bindingRecord.getArguments();
                    UUID bindingId = UUIDGenerator.generateBindingUUID((String)exchangeName, (String)queueName, (String)routingKey, (String)virtualHostName);
                    UpgradeConfiguredObjectRecord configuredObject = UpgradeFrom5To6.this.createBindingConfiguredObjectRecord(exchangeName, queueName, routingKey, arguments, virtualHostName);
                    UpgradeFrom5To6.this.storeConfiguredObjectEntry(configuredObjectsDatabase, bindingId, configuredObject, transaction);
                }
            };
            new DatabaseTemplate(environment, OLD_QUEUE_BINDINGS_DB_NAME, CONFIGURED_OBJECTS_DB_NAME, transaction).run(bindingCursor);
            environment.removeDatabase(transaction, OLD_QUEUE_BINDINGS_DB_NAME);
            LOGGER.info(bindingCursor.getRowCount() + " Queue Binding Entries");
        }
    }

    private List<String> upgradeExchanges(Environment environment, Transaction transaction, final String virtualHostName) {
        final ArrayList<String> exchangeNames = new ArrayList<String>();
        LOGGER.info("Exchanges");
        if (environment.getDatabaseNames().contains(OLD_EXCHANGE_DB_NAME)) {
            final ExchangeBinding exchangeBinding = new ExchangeBinding();
            CursorOperation exchangeCursor = new CursorOperation(){

                @Override
                public void processEntry(Database exchangeDatabase, Database configuredObjectsDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    ExchangeRecord exchangeRecord = (ExchangeRecord)exchangeBinding.entryToObject(value);
                    String exchangeName = exchangeRecord.getNameShortString().toString();
                    if (!DEFAULT_EXCHANGES_SET.contains(exchangeName) && !"<<default>>".equals(exchangeName)) {
                        String exchangeType = exchangeRecord.getType().toString();
                        boolean autoDelete = exchangeRecord.isAutoDelete();
                        UUID exchangeId = UUIDGenerator.generateExchangeUUID((String)exchangeName, (String)virtualHostName);
                        UpgradeConfiguredObjectRecord configuredObject = UpgradeFrom5To6.this.createExchangeConfiguredObjectRecord(exchangeName, exchangeType, autoDelete);
                        UpgradeFrom5To6.this.storeConfiguredObjectEntry(configuredObjectsDatabase, exchangeId, configuredObject, transaction);
                        exchangeNames.add(exchangeName);
                    }
                }
            };
            new DatabaseTemplate(environment, OLD_EXCHANGE_DB_NAME, CONFIGURED_OBJECTS_DB_NAME, transaction).run(exchangeCursor);
            environment.removeDatabase(transaction, OLD_EXCHANGE_DB_NAME);
            LOGGER.info(exchangeCursor.getRowCount() + " Exchange Entries");
        }
        return exchangeNames;
    }

    private List<String> upgradeQueues(Environment environment, Transaction transaction, final String virtualHostName) {
        final ArrayList<String> queueNames = new ArrayList<String>();
        LOGGER.info("Queues");
        if (environment.getDatabaseNames().contains(OLD_QUEUE_DB_NAME)) {
            final UpgradeQueueBinding queueBinding = new UpgradeQueueBinding();
            CursorOperation queueCursor = new CursorOperation(){

                @Override
                public void processEntry(Database queueDatabase, Database configuredObjectsDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    OldQueueRecord queueRecord = (OldQueueRecord)queueBinding.entryToObject(value);
                    String queueName = queueRecord.getNameShortString().toString();
                    queueNames.add(queueName);
                    String owner = queueRecord.getOwner() == null ? null : queueRecord.getOwner().toString();
                    boolean exclusive = queueRecord.isExclusive();
                    FieldTable arguments = queueRecord.getArguments();
                    UUID queueId = UUIDGenerator.generateQueueUUID((String)queueName, (String)virtualHostName);
                    UpgradeConfiguredObjectRecord configuredObject = UpgradeFrom5To6.this.createQueueConfiguredObjectRecord(queueName, owner, exclusive, arguments);
                    UpgradeFrom5To6.this.storeConfiguredObjectEntry(configuredObjectsDatabase, queueId, configuredObject, transaction);
                }
            };
            new DatabaseTemplate(environment, OLD_QUEUE_DB_NAME, CONFIGURED_OBJECTS_DB_NAME, transaction).run(queueCursor);
            environment.removeDatabase(transaction, OLD_QUEUE_DB_NAME);
            LOGGER.info(queueCursor.getRowCount() + " Queue Entries");
        }
        return queueNames;
    }

    private void storeConfiguredObjectEntry(Database configuredObjectsDatabase, UUID id, UpgradeConfiguredObjectRecord configuredObject, Transaction transaction) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        UpgradeUUIDBinding uuidBinding = new UpgradeUUIDBinding();
        uuidBinding.objectToEntry(id, key);
        ConfiguredObjectBinding configuredBinding = new ConfiguredObjectBinding();
        configuredBinding.objectToEntry(configuredObject, value);
        this.put(configuredObjectsDatabase, transaction, key, value);
    }

    private UpgradeConfiguredObjectRecord createQueueConfiguredObjectRecord(String queueName, String owner, boolean exclusive, FieldTable arguments) {
        Map<String, Object> attributesMap = this.buildQueueArgumentMap(queueName, owner, exclusive, arguments);
        String json = this.serialiseMap(attributesMap);
        UpgradeConfiguredObjectRecord configuredObject = new UpgradeConfiguredObjectRecord(Queue.class.getName(), json);
        return configuredObject;
    }

    private Map<String, Object> buildQueueArgumentMap(String queueName, String owner, boolean exclusive, FieldTable arguments) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", queueName);
        attributesMap.put("exclusive", exclusive);
        HashMap<String, String> argumentsCopy = new HashMap<String, String>();
        if (arguments != null) {
            argumentsCopy.putAll(FieldTable.convertToMap((FieldTable)arguments));
        }
        if (this.moveNonExclusiveOwnerToDescription(owner, exclusive)) {
            LOGGER.info("Non-exclusive owner " + owner + " for queue " + queueName + " moved to x-qpid-description");
            attributesMap.put("owner", null);
            argumentsCopy.put("x-qpid-description", owner);
        } else {
            attributesMap.put("owner", owner);
        }
        if (!argumentsCopy.isEmpty()) {
            attributesMap.put(ARGUMENTS, argumentsCopy);
        }
        return attributesMap;
    }

    private boolean moveNonExclusiveOwnerToDescription(String owner, boolean exclusive) {
        return !exclusive && owner != null && MOVE_NON_EXCLUSIVE_QUEUE_OWNER_TO_DESCRIPTION;
    }

    private UpgradeConfiguredObjectRecord createExchangeConfiguredObjectRecord(String exchangeName, String exchangeType, boolean autoDelete) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", exchangeName);
        attributesMap.put("type", exchangeType);
        attributesMap.put("lifetimePolicy", autoDelete ? "AUTO_DELETE" : LifetimePolicy.PERMANENT.name());
        String json = this.serialiseMap(attributesMap);
        UpgradeConfiguredObjectRecord configuredObject = new UpgradeConfiguredObjectRecord(Exchange.class.getName(), json);
        return configuredObject;
    }

    private UpgradeConfiguredObjectRecord createBindingConfiguredObjectRecord(String exchangeName, String queueName, String routingKey, FieldTable arguments, String virtualHostName) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", routingKey);
        attributesMap.put("exchange", UUIDGenerator.generateExchangeUUID((String)exchangeName, (String)virtualHostName));
        attributesMap.put("queue", UUIDGenerator.generateQueueUUID((String)queueName, (String)virtualHostName));
        if (arguments != null) {
            attributesMap.put(ARGUMENTS, FieldTable.convertToMap((FieldTable)arguments));
        }
        String json = this.serialiseMap(attributesMap);
        UpgradeConfiguredObjectRecord configuredObject = new UpgradeConfiguredObjectRecord(Binding.class.getName(), json);
        return configuredObject;
    }

    private void put(Database database, Transaction txn, DatabaseEntry key, DatabaseEntry value) {
        OperationStatus status = database.put(txn, key, value);
        if (status != OperationStatus.SUCCESS) {
            throw new StoreException("Cannot add record into " + database.getDatabaseName() + ":" + status);
        }
    }

    private String serialiseMap(Map<String, Object> attributesMap) {
        try {
            return this._serializer.serialize(attributesMap);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialise map " + attributesMap + " as JSON", e);
        }
    }

    static class OldPreparedTransactionBinding
    extends TupleBinding<OldPreparedTransaction> {
        OldPreparedTransactionBinding() {
        }

        public OldPreparedTransaction entryToObject(TupleInput input) {
            OldRecordImpl[] enqueues = this.readRecords(input);
            OldRecordImpl[] dequeues = this.readRecords(input);
            return new OldPreparedTransaction(enqueues, dequeues);
        }

        private OldRecordImpl[] readRecords(TupleInput input) {
            OldRecordImpl[] records = new OldRecordImpl[input.readInt()];
            for (int i = 0; i < records.length; ++i) {
                records[i] = new OldRecordImpl(input.readString(), input.readLong());
            }
            return records;
        }

        public void objectToEntry(OldPreparedTransaction preparedTransaction, TupleOutput output) {
            this.writeRecords(preparedTransaction.getEnqueues(), output);
            this.writeRecords(preparedTransaction.getDequeues(), output);
        }

        private void writeRecords(OldRecordImpl[] records, TupleOutput output) {
            if (records == null) {
                output.writeInt(0);
            } else {
                output.writeInt(records.length);
                for (OldRecordImpl record : records) {
                    output.writeString(record.getQueueName());
                    output.writeLong(record.getMessageNumber());
                }
            }
        }
    }

    static class OldPreparedTransaction {
        private final OldRecordImpl[] _enqueues;
        private final OldRecordImpl[] _dequeues;

        public OldPreparedTransaction(OldRecordImpl[] enqueues, OldRecordImpl[] dequeues) {
            this._enqueues = enqueues;
            this._dequeues = dequeues;
        }

        public OldRecordImpl[] getEnqueues() {
            return this._enqueues;
        }

        public OldRecordImpl[] getDequeues() {
            return this._dequeues;
        }
    }

    static class OldRecordImpl {
        private final long _messageNumber;
        private final String _queueName;

        public OldRecordImpl(String queueName, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueName = queueName;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public String getQueueName() {
            return this._queueName;
        }
    }

    static class NewPreparedTransactionBinding
    extends TupleBinding<NewPreparedTransaction> {
        NewPreparedTransactionBinding() {
        }

        public NewPreparedTransaction entryToObject(TupleInput input) {
            NewRecordImpl[] enqueues = this.readRecords(input);
            NewRecordImpl[] dequeues = this.readRecords(input);
            return new NewPreparedTransaction(enqueues, dequeues);
        }

        private NewRecordImpl[] readRecords(TupleInput input) {
            NewRecordImpl[] records = new NewRecordImpl[input.readInt()];
            for (int i = 0; i < records.length; ++i) {
                records[i] = new NewRecordImpl(new UUID(input.readLong(), input.readLong()), input.readLong());
            }
            return records;
        }

        public void objectToEntry(NewPreparedTransaction preparedTransaction, TupleOutput output) {
            this.writeRecords(preparedTransaction.getEnqueues(), output);
            this.writeRecords(preparedTransaction.getDequeues(), output);
        }

        private void writeRecords(NewRecordImpl[] records, TupleOutput output) {
            if (records == null) {
                output.writeInt(0);
            } else {
                output.writeInt(records.length);
                for (NewRecordImpl record : records) {
                    UUID id = record.getId();
                    output.writeLong(id.getMostSignificantBits());
                    output.writeLong(id.getLeastSignificantBits());
                    output.writeLong(record.getMessageNumber());
                }
            }
        }
    }

    static class NewRecordImpl {
        private final long _messageNumber;
        private final UUID _queueId;

        public NewRecordImpl(UUID queueId, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public UUID getId() {
            return this._queueId;
        }
    }

    static class NewPreparedTransaction {
        private final NewRecordImpl[] _enqueues;
        private final NewRecordImpl[] _dequeues;

        public NewPreparedTransaction(NewRecordImpl[] enqueues, NewRecordImpl[] dequeues) {
            this._enqueues = enqueues;
            this._dequeues = dequeues;
        }

        public NewRecordImpl[] getEnqueues() {
            return this._enqueues;
        }

        public NewRecordImpl[] getDequeues() {
            return this._dequeues;
        }
    }

    static class NewQueueEntryBinding
    extends TupleBinding<NewQueueEntryKey> {
        NewQueueEntryBinding() {
        }

        public NewQueueEntryKey entryToObject(TupleInput tupleInput) {
            UUID queueId = new UUID(tupleInput.readLong(), tupleInput.readLong());
            long messageId = tupleInput.readLong();
            return new NewQueueEntryKey(queueId, messageId);
        }

        public void objectToEntry(NewQueueEntryKey mk, TupleOutput tupleOutput) {
            UUID uuid = mk.getQueueId();
            tupleOutput.writeLong(uuid.getMostSignificantBits());
            tupleOutput.writeLong(uuid.getLeastSignificantBits());
            tupleOutput.writeLong(mk.getMessageId());
        }
    }

    static class NewQueueEntryKey {
        private final UUID _queueId;
        private final long _messageId;

        public NewQueueEntryKey(UUID queueId, long messageId) {
            this._queueId = queueId;
            this._messageId = messageId;
        }

        public UUID getQueueId() {
            return this._queueId;
        }

        public long getMessageId() {
            return this._messageId;
        }
    }

    static class OldQueueEntryBinding
    extends TupleBinding<OldQueueEntryKey> {
        OldQueueEntryBinding() {
        }

        public OldQueueEntryKey entryToObject(TupleInput tupleInput) {
            AMQShortString queueName = AMQShortStringEncoding.readShortString(tupleInput);
            long messageId = tupleInput.readLong();
            return new OldQueueEntryKey(queueName, messageId);
        }

        public void objectToEntry(OldQueueEntryKey mk, TupleOutput tupleOutput) {
            AMQShortStringEncoding.writeShortString(mk.getQueueName(), tupleOutput);
            tupleOutput.writeLong(mk.getMessageId());
        }
    }

    static class OldQueueEntryKey {
        private final AMQShortString _queueName;
        private final long _messageId;

        public OldQueueEntryKey(AMQShortString queueName, long messageId) {
            this._queueName = queueName;
            this._messageId = messageId;
        }

        public AMQShortString getQueueName() {
            return this._queueName;
        }

        public long getMessageId() {
            return this._messageId;
        }
    }

    static class QueueBindingBinding
    extends TupleBinding<BindingRecord> {
        QueueBindingBinding() {
        }

        public BindingRecord entryToObject(TupleInput tupleInput) {
            AMQShortString exchangeName = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString queueName = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString routingKey = AMQShortStringEncoding.readShortString(tupleInput);
            FieldTable arguments = FieldTableEncoding.readFieldTable(tupleInput);
            return new BindingRecord(exchangeName, queueName, routingKey, arguments);
        }

        public void objectToEntry(BindingRecord binding, TupleOutput tupleOutput) {
            AMQShortStringEncoding.writeShortString(binding.getExchangeName(), tupleOutput);
            AMQShortStringEncoding.writeShortString(binding.getQueueName(), tupleOutput);
            AMQShortStringEncoding.writeShortString(binding.getRoutingKey(), tupleOutput);
            FieldTableEncoding.writeFieldTable(binding.getArguments(), tupleOutput);
        }
    }

    static class BindingRecord {
        private final AMQShortString _exchangeName;
        private final AMQShortString _queueName;
        private final AMQShortString _routingKey;
        private final FieldTable _arguments;

        public BindingRecord(AMQShortString exchangeName, AMQShortString queueName, AMQShortString routingKey, FieldTable arguments) {
            this._exchangeName = exchangeName;
            this._queueName = queueName;
            this._routingKey = routingKey;
            this._arguments = arguments;
        }

        public AMQShortString getExchangeName() {
            return this._exchangeName;
        }

        public AMQShortString getQueueName() {
            return this._queueName;
        }

        public AMQShortString getRoutingKey() {
            return this._routingKey;
        }

        public FieldTable getArguments() {
            return this._arguments;
        }
    }

    static class ExchangeBinding
    extends TupleBinding<ExchangeRecord> {
        ExchangeBinding() {
        }

        public ExchangeRecord entryToObject(TupleInput tupleInput) {
            AMQShortString name = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString typeName = AMQShortStringEncoding.readShortString(tupleInput);
            boolean autoDelete = tupleInput.readBoolean();
            return new ExchangeRecord(name, typeName, autoDelete);
        }

        public void objectToEntry(ExchangeRecord exchange, TupleOutput tupleOutput) {
            AMQShortStringEncoding.writeShortString(exchange.getNameShortString(), tupleOutput);
            AMQShortStringEncoding.writeShortString(exchange.getType(), tupleOutput);
            tupleOutput.writeBoolean(exchange.isAutoDelete());
        }
    }

    static class ExchangeRecord {
        private final AMQShortString _exchangeName;
        private final AMQShortString _exchangeType;
        private final boolean _autoDelete;

        public ExchangeRecord(AMQShortString exchangeName, AMQShortString exchangeType, boolean autoDelete) {
            this._exchangeName = exchangeName;
            this._exchangeType = exchangeType;
            this._autoDelete = autoDelete;
        }

        public AMQShortString getNameShortString() {
            return this._exchangeName;
        }

        public AMQShortString getType() {
            return this._exchangeType;
        }

        public boolean isAutoDelete() {
            return this._autoDelete;
        }
    }

    static class ConfiguredObjectBinding
    extends TupleBinding<UpgradeConfiguredObjectRecord> {
        ConfiguredObjectBinding() {
        }

        public UpgradeConfiguredObjectRecord entryToObject(TupleInput tupleInput) {
            String type = tupleInput.readString();
            String json = tupleInput.readString();
            UpgradeConfiguredObjectRecord configuredObject = new UpgradeConfiguredObjectRecord(type, json);
            return configuredObject;
        }

        public void objectToEntry(UpgradeConfiguredObjectRecord object, TupleOutput tupleOutput) {
            tupleOutput.writeString(object.getType());
            tupleOutput.writeString(object.getAttributes());
        }
    }

    static class UpgradeUUIDBinding
    extends TupleBinding<UUID> {
        UpgradeUUIDBinding() {
        }

        public UUID entryToObject(TupleInput tupleInput) {
            return new UUID(tupleInput.readLong(), tupleInput.readLong());
        }

        public void objectToEntry(UUID uuid, TupleOutput tupleOutput) {
            tupleOutput.writeLong(uuid.getMostSignificantBits());
            tupleOutput.writeLong(uuid.getLeastSignificantBits());
        }
    }

    static class UpgradeQueueBinding
    extends TupleBinding<OldQueueRecord> {
        UpgradeQueueBinding() {
        }

        public OldQueueRecord entryToObject(TupleInput tupleInput) {
            AMQShortString name = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString owner = AMQShortStringEncoding.readShortString(tupleInput);
            FieldTable arguments = FieldTableEncoding.readFieldTable(tupleInput);
            boolean exclusive = tupleInput.readBoolean();
            return new OldQueueRecord(name, owner, exclusive, arguments);
        }

        public void objectToEntry(OldQueueRecord queue, TupleOutput tupleOutput) {
            AMQShortStringEncoding.writeShortString(queue.getNameShortString(), tupleOutput);
            AMQShortStringEncoding.writeShortString(queue.getOwner(), tupleOutput);
            FieldTableEncoding.writeFieldTable(queue.getArguments(), tupleOutput);
            tupleOutput.writeBoolean(queue.isExclusive());
        }
    }

    static class UpgradeConfiguredObjectRecord {
        private final String _attributes;
        private final String _type;

        public UpgradeConfiguredObjectRecord(String type, String attributes) {
            this._attributes = attributes;
            this._type = type;
        }

        public String getAttributes() {
            return this._attributes;
        }

        public String getType() {
            return this._type;
        }
    }

    static class OldQueueRecord {
        private final AMQShortString _queueName;
        private final AMQShortString _owner;
        private final FieldTable _arguments;
        private boolean _exclusive;

        public OldQueueRecord(AMQShortString queueName, AMQShortString owner, boolean exclusive, FieldTable arguments) {
            this._queueName = queueName;
            this._owner = owner;
            this._exclusive = exclusive;
            this._arguments = arguments;
        }

        public AMQShortString getNameShortString() {
            return this._queueName;
        }

        public AMQShortString getOwner() {
            return this._owner;
        }

        public boolean isExclusive() {
            return this._exclusive;
        }

        public void setExclusive(boolean exclusive) {
            this._exclusive = exclusive;
        }

        public FieldTable getArguments() {
            return this._arguments;
        }
    }

    static final class NewDataBinding
    extends TupleBinding<byte[]> {
        NewDataBinding() {
        }

        public byte[] entryToObject(TupleInput input) {
            byte[] data = new byte[input.available()];
            input.read(data);
            return data;
        }

        public void objectToEntry(byte[] data, TupleOutput output) {
            output.write(data);
        }
    }

    static final class OldDataBinding
    extends TupleBinding<OldDataValue> {
        OldDataBinding() {
        }

        public OldDataValue entryToObject(TupleInput input) {
            int size = input.readInt();
            byte[] data = new byte[size];
            input.read(data);
            return new OldDataValue(size, data);
        }

        public void objectToEntry(OldDataValue value, TupleOutput output) {
            output.writeInt(value.getSize());
            output.write(value.getData());
        }
    }

    static final class OldDataValue {
        private final int _size;
        private final byte[] _data;

        private OldDataValue(int size, byte[] data) {
            this._size = size;
            this._data = data;
        }

        public int getSize() {
            return this._size;
        }

        public byte[] getData() {
            return this._data;
        }
    }

    static final class CompoundKeyBinding
    extends TupleBinding<CompoundKey> {
        CompoundKeyBinding() {
        }

        public CompoundKey entryToObject(TupleInput input) {
            return new CompoundKey(input.readLong(), input.readInt());
        }

        public void objectToEntry(CompoundKey object, TupleOutput output) {
            output.writeLong(object._messageId);
            output.writeInt(object._offset);
        }
    }

    static final class CompoundKey {
        public final long _messageId;
        public final int _offset;

        public CompoundKey(long messageId, int offset) {
            this._messageId = messageId;
            this._offset = offset;
        }

        public long getMessageId() {
            return this._messageId;
        }

        public int getOffset() {
            return this._offset;
        }
    }
}

