/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.berkeleydb;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.NotFoundException;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.berkeleydb.BDBVirtualHostImpl;

final class BDBVirtualHostImplWithAccessChecking
extends BDBVirtualHostImpl {
    private static final FixedKeyMapCreator GET_CONNECTION_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"name"});
    private static final FixedKeyMapCreator PUBLISH_MESSAGE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"message"});
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"includeSecureAttributes"});
    private static final FixedKeyMapCreator IMPORT_MESSAGE_STORE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"source"});
    private static final FixedKeyMapCreator PURGE_LINK_REGISTRY_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"containerIdPattern", "role", "linkNamePattern"});
    private static final FixedKeyMapCreator CLEAR_MATCHING_QUEUES_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"queueNamePattern"});
    private static final FixedKeyMapCreator CLEAR_QUEUES_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"queues"});
    private static final FixedKeyMapCreator CHECKPOINT_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"force"});
    private static final FixedKeyMapCreator ENVIRONMENT_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"reset"});
    private static final FixedKeyMapCreator TRANSACTION_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"reset"});
    private static final FixedKeyMapCreator DATABASE_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"database", "reset"});

    BDBVirtualHostImplWithAccessChecking(Map<String, Object> attributes, VirtualHostNode<?> virtualhostnode) {
        super(attributes, virtualhostnode);
    }

    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    public String setContextVariable(final String name, final String value) {
        return (String)this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BDBVirtualHostImplWithAccessChecking.super.setContextVariable(name, value));
            }

            public String getObject() {
                return BDBVirtualHostImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "setContextVariable";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    public String removeContextVariable(final String name) {
        return (String)this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BDBVirtualHostImplWithAccessChecking.super.removeContextVariable(name));
            }

            public String getObject() {
                return BDBVirtualHostImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "removeContextVariable";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    public Collection<? extends Connection<?>> getConnections() {
        return super.getConnections();
    }

    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD((String)"resetStatistics"));
        this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            public ListenableFuture<Void> execute() {
                BDBVirtualHostImplWithAccessChecking.super.resetStatistics();
                return Futures.immediateFuture(null);
            }

            public String getObject() {
                return BDBVirtualHostImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "resetStatistics";
            }

            public String getArguments() {
                return this._args;
            }
        }));
    }

    public Connection<?> getConnection(String name) {
        this.authorise(Operation.INVOKE_METHOD((String)"getConnection"), GET_CONNECTION_MAP_CREATOR.createMap(new Object[]{name}));
        return super.getConnection(name);
    }

    public int publishMessage(ManageableMessage message) {
        this.authorise(Operation.INVOKE_METHOD((String)"publishMessage"), PUBLISH_MESSAGE_MAP_CREATOR.createMap(new Object[]{message}));
        return super.publishMessage(message);
    }

    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.INVOKE_METHOD((String)"extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(new Object[]{includeSecureAttributes}));
        return super.extractConfig(includeSecureAttributes);
    }

    public Content exportMessageStore() {
        this.authorise(Operation.INVOKE_METHOD((String)"exportMessageStore"));
        return super.exportMessageStore();
    }

    public void importMessageStore(String source) {
        this.authorise(Operation.INVOKE_METHOD((String)"importMessageStore"), IMPORT_MESSAGE_STORE_MAP_CREATOR.createMap(new Object[]{source}));
        super.importMessageStore(source);
    }

    public SocketConnectionMetaData getConnectionMetaData() {
        return super.getConnectionMetaData();
    }

    public Object dumpLinkRegistry() {
        this.authorise(Operation.INVOKE_METHOD((String)"dumpLinkRegistry"));
        return super.dumpLinkRegistry();
    }

    public void purgeLinkRegistry(String containerIdPattern, String role, String linkNamePattern) {
        this.authorise(Operation.INVOKE_METHOD((String)"purgeLinkRegistry"), PURGE_LINK_REGISTRY_MAP_CREATOR.createMap(new Object[]{containerIdPattern, role, linkNamePattern}));
        super.purgeLinkRegistry(containerIdPattern, role, linkNamePattern);
    }

    public long clearMatchingQueues(String queueNamePattern) {
        this.authorise(Operation.INVOKE_METHOD((String)"clearMatchingQueues"), CLEAR_MATCHING_QUEUES_MAP_CREATOR.createMap(new Object[]{queueNamePattern}));
        return super.clearMatchingQueues(queueNamePattern);
    }

    public long clearQueues(Collection<String> queues) {
        this.authorise(Operation.INVOKE_METHOD((String)"clearQueues"), CLEAR_QUEUES_MAP_CREATOR.createMap(new Object[]{queues}));
        return super.clearQueues(queues);
    }

    public Queue<?> getSubscriptionQueue(final String exchangeName, final Map<String, Object> attributes, final Map<String, Map<String, Object>> bindings) {
        return (Queue)this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Queue<?>>, RuntimeException>(){
            private String _args;

            public ListenableFuture<Queue<?>> execute() {
                return Futures.immediateFuture((Object)BDBVirtualHostImplWithAccessChecking.super.getSubscriptionQueue(exchangeName, attributes, bindings));
            }

            public String getObject() {
                return BDBVirtualHostImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "getSubscriptionQueue";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "exchangeName=" + exchangeName + ",attributes=" + attributes + ",bindings=" + bindings;
                }
                return this._args;
            }
        }));
    }

    public void removeSubscriptionQueue(final String queueName) throws NotFoundException {
        this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            public ListenableFuture<Void> execute() {
                try {
                    BDBVirtualHostImplWithAccessChecking.super.removeSubscriptionQueue(queueName);
                    return Futures.immediateFuture(null);
                }
                catch (NotFoundException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }

            public String getObject() {
                return BDBVirtualHostImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "removeSubscriptionQueue";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "queueName=" + queueName;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void updateMutableConfig() {
        this.authorise(Operation.INVOKE_METHOD((String)"updateMutableConfig"));
        super.updateMutableConfig();
    }

    @Override
    public int cleanLog() {
        this.authorise(Operation.INVOKE_METHOD((String)"cleanLog"));
        return super.cleanLog();
    }

    @Override
    public void checkpoint(boolean force) {
        this.authorise(Operation.INVOKE_METHOD((String)"checkpoint"), CHECKPOINT_MAP_CREATOR.createMap(new Object[]{force}));
        super.checkpoint(force);
    }

    @Override
    public Map<String, Map<String, Object>> environmentStatistics(boolean reset) {
        this.authorise(Operation.INVOKE_METHOD((String)"environmentStatistics"), ENVIRONMENT_STATISTICS_MAP_CREATOR.createMap(new Object[]{reset}));
        return super.environmentStatistics(reset);
    }

    @Override
    public Map<String, Object> transactionStatistics(boolean reset) {
        this.authorise(Operation.INVOKE_METHOD((String)"transactionStatistics"), TRANSACTION_STATISTICS_MAP_CREATOR.createMap(new Object[]{reset}));
        return super.transactionStatistics(reset);
    }

    @Override
    public Map<String, Object> databaseStatistics(String database, boolean reset) {
        this.authorise(Operation.INVOKE_METHOD((String)"databaseStatistics"), DATABASE_STATISTICS_MAP_CREATOR.createMap(new Object[]{database, reset}));
        return super.databaseStatistics(database, reset);
    }
}

