/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContext;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContextHolder;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Metadata;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;

public abstract class AbstractExpressionNode<T, R>
implements ExpressionNode<T, R> {
    protected final Metadata<T> _metadata = new Metadata();
    private ExpressionNode<T, ?> _parent;
    private final List<ExpressionNode<T, ?>> _children = new ArrayList();

    public AbstractExpressionNode() {
        if (this.ctx().isBuilding()) {
            this.ctx().incrementDepth();
        }
        int depth = this.ctx().getDepth();
        QuerySettings querySettings = (QuerySettings)this.ctx().get("query.settings");
        if (!this.ctx().isExecuting() && depth >= querySettings.getMaxQueryDepth()) {
            throw QueryParsingException.of("Max query depth reached: %d", this.ctx().getDepth());
        }
    }

    public AbstractExpressionNode(String alias) {
        this();
        this._metadata.setAlias(alias);
    }

    public AbstractExpressionNode(ExpressionNode<T, ?> first) {
        this(Collections.singletonList(first));
    }

    public AbstractExpressionNode(String alias, ExpressionNode<T, ?> first) {
        this(alias, Collections.singletonList(first));
    }

    public AbstractExpressionNode(ExpressionNode<T, ?> first, ExpressionNode<T, ?> second) {
        this(Arrays.asList(first, second));
    }

    public AbstractExpressionNode(String alias, ExpressionNode<T, ?> first, ExpressionNode<T, ?> second) {
        this(alias, Arrays.asList(first, second));
    }

    public AbstractExpressionNode(ExpressionNode<T, ?> first, ExpressionNode<T, ?> second, ExpressionNode<T, ?> third) {
        this(Arrays.asList(first, second, third));
    }

    public AbstractExpressionNode(List<ExpressionNode<T, ?>> children) {
        this();
        if (children != null) {
            for (ExpressionNode<T, R> expressionNode : children) {
                this._children.add(expressionNode);
                expressionNode.setParent(this);
                if (expressionNode instanceof AbstractAggregationExpression) {
                    this._metadata.addAggregation((AbstractAggregationExpression)expressionNode);
                }
                if (expressionNode.containsAggregation()) {
                    expressionNode.getAggregations().forEach(this._metadata::addAggregation);
                }
                this._metadata.setAccessor(expressionNode.isAccessor());
            }
        }
    }

    public AbstractExpressionNode(String alias, List<ExpressionNode<T, ?>> children) {
        this(children);
        this._metadata.setAlias(alias);
    }

    protected final EvaluationContext ctx() {
        return EvaluationContextHolder.getEvaluationContext();
    }

    @Override
    public <Y> ExpressionNode<T, Y> getParent() {
        return this._parent;
    }

    @Override
    public void setParent(ExpressionNode<T, ?> parent) {
        this._parent = parent;
    }

    protected <X, Y> ExpressionNode<X, Y> getChild(int index) {
        return this._children.size() - 1 < index ? null : this._children.get(index);
    }

    protected <X, Y> Y evaluateChild(int index, X value) {
        ExpressionNode<X, Y> child = this.getChild(index);
        if (child == null) {
            throw QueryEvaluationException.of("Child expression of parent '%s' with index %d not found", this.getAlias(), index);
        }
        return (Y)child.apply(value);
    }

    @Override
    public <Y> List<ExpressionNode<T, Y>> getChildren() {
        return this._children.stream().map(item -> item).collect(Collectors.toList());
    }

    @Override
    public boolean containsAggregation() {
        return this._metadata.isAggregation();
    }

    @Override
    public boolean isAccessor() {
        return this._metadata.isAccessor();
    }

    @Override
    public boolean isInstantlyEvaluable() {
        return this.getChildren().stream().allMatch(ConstantExpression.class::isInstance);
    }

    @Override
    public String getAlias() {
        return this._metadata.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this._metadata.setAlias(alias);
    }

    @Override
    public <Y> List<AbstractAggregationExpression<T, Y>> getAggregations() {
        return this._metadata.getAggregations().stream().map(expression -> expression).collect(Collectors.toList());
    }

    public String toString() {
        return this.getAlias();
    }
}

