/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class GcTimeMonitor
extends Thread {
    private final long maxGcTimePercentage;
    private final long observationWindowNanos;
    private final long sleepIntervalMs;
    private final GcTimeAlertHandler alertHandler;
    private final TsAndData[] gcDataBuf;
    private int bufSize;
    private int startIdx;
    private int endIdx;
    private long startTimeNanos;
    private final GcData curData = new GcData();
    private volatile boolean shouldRun = true;

    public GcTimeMonitor(long observationWindowMs, long sleepIntervalMs, int maxGcTimePercentage, GcTimeAlertHandler alertHandler) {
        Preconditions.checkArgument((observationWindowMs > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((sleepIntervalMs > 0L && sleepIntervalMs < observationWindowMs ? 1 : 0) != 0);
        Preconditions.checkArgument((maxGcTimePercentage >= 0 && maxGcTimePercentage <= 100 ? 1 : 0) != 0);
        this.observationWindowNanos = observationWindowMs * 1000000L;
        this.sleepIntervalMs = sleepIntervalMs;
        this.maxGcTimePercentage = maxGcTimePercentage;
        this.alertHandler = alertHandler;
        this.bufSize = (int)(observationWindowMs / sleepIntervalMs + 2L);
        Preconditions.checkArgument((this.bufSize <= 131072 ? 1 : 0) != 0);
        this.gcDataBuf = new TsAndData[this.bufSize];
        for (int i = 0; i < this.bufSize; ++i) {
            this.gcDataBuf[i] = new TsAndData();
        }
        this.setDaemon(true);
        this.setName("GcTimeMonitor obsWindow = " + observationWindowMs + ", sleepInterval = " + sleepIntervalMs + ", maxGcTimePerc = " + maxGcTimePercentage);
    }

    @Override
    public void run() {
        this.startTimeNanos = System.nanoTime();
        this.gcDataBuf[this.startIdx].setValues(this.startTimeNanos, 0L);
        while (this.shouldRun) {
            long intervalStartTsNanos = System.nanoTime();
            try {
                Thread.sleep(this.sleepIntervalMs);
            }
            catch (InterruptedException ie) {
                return;
            }
            long intervalEndTsNanos = System.nanoTime();
            this.calculateGCTimePercentageWithinObservedInterval(intervalStartTsNanos, intervalEndTsNanos);
            if (this.alertHandler == null || (long)this.curData.gcTimePercentage <= this.maxGcTimePercentage) continue;
            this.alertHandler.alert(this.curData.clone());
        }
    }

    public void shutdown() {
        this.shouldRun = false;
    }

    public GcData getLatestGcData() {
        return this.curData.clone();
    }

    private void calculateGCTimePercentageWithinObservedInterval(long intervalStartTsNanos, long intervalEndTsNanos) {
        long gcTimeWithinSleepIntervalNanos = intervalEndTsNanos - intervalStartTsNanos - this.sleepIntervalMs * 1000000L;
        long totalGcTimeNanos = this.curData.totalGcTimeNanos + gcTimeWithinSleepIntervalNanos;
        long gcMonitorRunTimeNanos = intervalEndTsNanos - this.startTimeNanos;
        this.endIdx = (this.endIdx + 1) % this.bufSize;
        this.gcDataBuf[this.endIdx].setValues(intervalEndTsNanos, gcTimeWithinSleepIntervalNanos);
        long startObsWindowTsNanos = intervalEndTsNanos - this.observationWindowNanos;
        while (this.gcDataBuf[this.startIdx].tsNanos < startObsWindowTsNanos && this.startIdx != this.endIdx) {
            this.startIdx = (this.startIdx + 1) % this.bufSize;
        }
        long gcTimeWithinObservationWindowNanos = Math.min(this.gcDataBuf[this.startIdx].gcPauseNanos, this.gcDataBuf[this.startIdx].tsNanos - startObsWindowTsNanos);
        if (this.startIdx != this.endIdx) {
            int i = (this.startIdx + 1) % this.bufSize;
            while (i != this.endIdx) {
                gcTimeWithinObservationWindowNanos += this.gcDataBuf[i].gcPauseNanos;
                i = (i + 1) % this.bufSize;
            }
        }
        this.curData.update(gcMonitorRunTimeNanos, totalGcTimeNanos, (int)(gcTimeWithinObservationWindowNanos * 100L / Math.min(this.observationWindowNanos, gcMonitorRunTimeNanos)));
    }

    public static void main(String[] args) throws Exception {
        new GcTimeMonitor(20000L, 500L, 20, new GcTimeAlertHandler(){

            @Override
            public void alert(GcData gcData) {
                System.err.println("GcTimeMonitor alert. Current GC time percentage = " + gcData.getGcTimePercentage() + ", total run time = " + gcData.getGcMonitorRunTimeMs() / 1000L + " sec, total GC time = " + gcData.getAccumulatedGcTimeMs() / 1000L + " sec");
            }
        }).start();
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (true) {
            list.add("This is a long string to fill memory quickly " + i);
            if (i % 100000 == 0) {
                System.out.println("Added " + i + " strings");
                Thread.sleep(100L);
            }
            ++i;
        }
    }

    private static class TsAndData {
        private long tsNanos;
        private long gcPauseNanos;

        private TsAndData() {
        }

        void setValues(long tsNanos, long gcPauseNanos) {
            this.tsNanos = tsNanos;
            this.gcPauseNanos = gcPauseNanos;
        }
    }

    public static class GcData
    implements Cloneable {
        private long gcMonitorRunTimeNanos;
        private long totalGcTimeNanos;
        private int gcTimePercentage;

        public long getGcMonitorRunTimeMs() {
            return this.gcMonitorRunTimeNanos / 1000000L;
        }

        public long getAccumulatedGcTimeMs() {
            return this.totalGcTimeNanos / 1000000L;
        }

        public int getGcTimePercentage() {
            return this.gcTimePercentage;
        }

        private synchronized void update(long gcMonitorRunTimeNanos, long totalGcTimeNanos, int inGcTimePercentage) {
            this.gcMonitorRunTimeNanos = gcMonitorRunTimeNanos;
            this.totalGcTimeNanos = totalGcTimeNanos;
            this.gcTimePercentage = inGcTimePercentage;
        }

        public synchronized GcData clone() {
            try {
                return (GcData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface GcTimeAlertHandler {
        public void alert(GcData var1);
    }
}

