/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializationSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationSnapshot.class);
    private String validTxnList;
    private Map<String, SnapshotContext> tableSnapshots;

    public static MaterializationSnapshot fromJson(String jsonString) {
        try {
            return (MaterializationSnapshot)new ObjectMapper().readValue(jsonString, MaterializationSnapshot.class);
        }
        catch (JsonProcessingException e) {
            LOG.warn(String.format("Unable to parse string as json '%s'. Falling back to parse it as a ValidTxnWriteIdList", jsonString), (Throwable)e);
            return new MaterializationSnapshot(jsonString);
        }
    }

    private MaterializationSnapshot() {
    }

    public MaterializationSnapshot(String validTxnList) {
        this.validTxnList = validTxnList;
        this.tableSnapshots = null;
    }

    public MaterializationSnapshot(Map<String, SnapshotContext> tableSnapshots) {
        this.validTxnList = null;
        this.tableSnapshots = tableSnapshots;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String asJsonString() {
        try (StringWriter out = new StringWriter();){
            new ObjectMapper().writeValue((Writer)out, (Object)this);
            String string = ((Object)out).toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to convert " + this + " to json", e);
        }
    }

    public String toString() {
        return "MaterializationSnapshot{validTxnList='" + this.validTxnList + '\'' + ", tableSnapshots=" + this.tableSnapshots + '}';
    }

    public String getValidTxnList() {
        return this.validTxnList;
    }

    public Map<String, SnapshotContext> getTableSnapshots() {
        return this.tableSnapshots;
    }
}

