/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.ReadOnlyException;

public abstract class BaseBuffer
extends BaseState {
    private long capacity;
    private long start = 0L;
    private long pos = 0L;
    private long end;

    BaseBuffer(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
        this.capacity = this.end = capacityBytes;
    }

    public final BaseBuffer incrementPosition(long increment) {
        this.incrementAndAssertPositionForRead(this.pos, increment);
        return this;
    }

    public final BaseBuffer incrementAndCheckPosition(long increment) {
        this.incrementAndCheckPositionForRead(this.pos, increment);
        return this;
    }

    public final long getEnd() {
        return this.end;
    }

    public final long getPosition() {
        return this.pos;
    }

    public final long getStart() {
        return this.start;
    }

    public final long getRemaining() {
        return this.end - this.pos;
    }

    public final boolean hasRemaining() {
        return this.end - this.pos > 0L;
    }

    public final BaseBuffer resetPosition() {
        this.pos = this.start;
        return this;
    }

    public final BaseBuffer setPosition(long position) {
        BaseBuffer.assertInvariants(this.start, position, this.end, this.capacity);
        this.pos = position;
        return this;
    }

    public final BaseBuffer setAndCheckPosition(long position) {
        BaseBuffer.checkInvariants(this.start, position, this.end, this.capacity);
        this.pos = position;
        return this;
    }

    public final BaseBuffer setStartPositionEnd(long start, long position, long end) {
        BaseBuffer.assertInvariants(start, position, end, this.capacity);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    public final BaseBuffer setAndCheckStartPositionEnd(long start, long position, long end) {
        BaseBuffer.checkInvariants(start, position, end, this.capacity);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    final void incrementAndAssertPositionForRead(long position, long increment) {
        this.assertValid();
        long newPos = position + increment;
        BaseBuffer.assertInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void incrementAndAssertPositionForWrite(long position, long increment) {
        this.assertValid();
        assert (!this.isReadOnly()) : "Buffer is read-only.";
        long newPos = position + increment;
        BaseBuffer.assertInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void incrementAndCheckPositionForRead(long position, long increment) {
        this.checkValid();
        long newPos = position + increment;
        BaseBuffer.checkInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void incrementAndCheckPositionForWrite(long position, long increment) {
        this.checkValidForWrite();
        long newPos = position + increment;
        BaseBuffer.checkInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void checkValidForWrite() {
        this.checkValid();
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Buffer is read-only.");
        }
    }

    static final void assertInvariants(long start, long pos, long end, long cap) {
        assert ((start | pos | end | cap | pos - start | end - pos | cap - end) >= 0L) : "Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end);
    }

    static final void checkInvariants(long start, long pos, long end, long cap) {
        if ((start | pos | end | cap | pos - start | end - pos | cap - end) < 0L) {
            throw new IllegalArgumentException("Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end));
        }
    }
}

