/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.rfile.FSConfArgs;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class RFileWriterBuilder
implements RFile.OutputArguments,
RFile.WriterFSOptions {
    private OutputArgs out;
    private SamplerConfiguration sampler = null;
    private Map<String, String> tableConfig = Collections.emptyMap();
    private int visCacheSize = 1000;

    RFileWriterBuilder() {
    }

    @Override
    public RFile.WriterOptions withSampler(SamplerConfiguration samplerConf) {
        Objects.requireNonNull(samplerConf);
        SamplerConfigurationImpl.checkDisjoint(this.tableConfig, samplerConf);
        this.sampler = samplerConf;
        return this;
    }

    @Override
    public RFileWriter build() throws IOException {
        FileOperations fileops = FileOperations.getInstance();
        AccumuloConfiguration acuconf = AccumuloConfiguration.getDefaultConfiguration();
        HashMap<String, String> userProps = new HashMap<String, String>();
        if (this.sampler != null) {
            userProps.putAll(new SamplerConfigurationImpl(this.sampler).toTablePropertiesMap());
        }
        userProps.putAll(this.tableConfig);
        if (userProps.size() > 0) {
            acuconf = new ConfigurationCopy(Iterables.concat((Iterable)acuconf, userProps.entrySet()));
        }
        if (this.out.getOutputStream() != null) {
            FSDataOutputStream fsdo = this.out.getOutputStream() instanceof FSDataOutputStream ? (FSDataOutputStream)this.out.getOutputStream() : new FSDataOutputStream(this.out.getOutputStream(), new FileSystem.Statistics("foo"));
            return new RFileWriter(fileops.newWriterBuilder().forOutputStream(".rf", fsdo, this.out.getConf()).withTableConfiguration(acuconf).build(), this.visCacheSize);
        }
        return new RFileWriter(((FileOperations.OpenWriterOperationBuilder)fileops.newWriterBuilder().forFile(this.out.path.toString(), this.out.getFileSystem(), this.out.getConf()).withTableConfiguration(acuconf)).build(), this.visCacheSize);
    }

    @Override
    public RFile.WriterOptions withFileSystem(FileSystem fs) {
        Objects.requireNonNull(fs);
        this.out.fs = fs;
        return this;
    }

    @Override
    public RFile.WriterFSOptions to(String filename) {
        Objects.requireNonNull(filename);
        this.out = new OutputArgs(filename);
        return this;
    }

    @Override
    public RFile.WriterOptions to(OutputStream out) {
        Objects.requireNonNull(out);
        this.out = new OutputArgs(out);
        return this;
    }

    @Override
    public RFile.WriterOptions withTableProperties(Iterable<Map.Entry<String, String>> tableConfig) {
        Objects.requireNonNull(tableConfig);
        HashMap<String, String> cfg = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : tableConfig) {
            cfg.put(entry.getKey(), entry.getValue());
        }
        SamplerConfigurationImpl.checkDisjoint(cfg, this.sampler);
        this.tableConfig = cfg;
        return this;
    }

    @Override
    public RFile.WriterOptions withTableProperties(Map<String, String> tableConfig) {
        Objects.requireNonNull(tableConfig);
        return this.withTableProperties(tableConfig.entrySet());
    }

    @Override
    public RFile.WriterOptions withVisibilityCacheSize(int maxSize) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
        this.visCacheSize = maxSize;
        return this;
    }

    private static class OutputArgs
    extends FSConfArgs {
        private Path path;
        private OutputStream out;

        OutputArgs(String filename) {
            this.path = new Path(filename);
        }

        OutputArgs(OutputStream out) {
            this.out = out;
        }

        OutputStream getOutputStream() {
            return this.out;
        }
    }
}

