/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mapreduce.impl.SplitUtils;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.DeprecationUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.log4j.Level;

public class RangeInputSplit
extends InputSplit
implements Writable {
    private Range range;
    private String[] locations;
    private String tableId;
    private String tableName;
    private String instanceName;
    private String zooKeepers;
    private String principal;
    private ConfiguratorBase.TokenSource tokenSource;
    private String tokenFile;
    private AuthenticationToken token;
    private Boolean offline;
    private Boolean mockInstance;
    private Boolean isolatedScan;
    private Boolean localIterators;
    private Authorizations auths;
    private Set<Pair<Text, Text>> fetchedColumns;
    private List<IteratorSetting> iterators;
    private SamplerConfiguration samplerConfig;
    private Level level;

    public RangeInputSplit() {
        this.range = new Range();
        this.locations = new String[0];
        this.tableName = "";
        this.tableId = "";
    }

    public RangeInputSplit(RangeInputSplit split) throws IOException {
        this.range = split.getRange();
        this.setLocations(split.getLocations());
        this.setTableName(split.getTableName());
        this.setTableId(split.getTableId());
    }

    protected RangeInputSplit(String table, String tableId, Range range, String[] locations) {
        this.range = range;
        this.setLocations(locations);
        this.tableName = table;
        this.tableId = tableId;
    }

    public Range getRange() {
        return this.range;
    }

    public static float getProgress(ByteSequence start, ByteSequence end, ByteSequence position) {
        return SplitUtils.getProgress(start, end, position);
    }

    public float getProgress(Key currentKey) {
        if (currentKey == null) {
            return 0.0f;
        }
        if (this.range.contains(currentKey) && this.range.getStartKey() != null && this.range.getEndKey() != null) {
            if (this.range.getStartKey().compareTo(this.range.getEndKey(), PartialKey.ROW) != 0) {
                return RangeInputSplit.getProgress(this.range.getStartKey().getRowData(), this.range.getEndKey().getRowData(), currentKey.getRowData());
            }
            if (this.range.getStartKey().compareTo(this.range.getEndKey(), PartialKey.ROW_COLFAM) != 0) {
                return RangeInputSplit.getProgress(this.range.getStartKey().getColumnFamilyData(), this.range.getEndKey().getColumnFamilyData(), currentKey.getColumnFamilyData());
            }
            if (this.range.getStartKey().compareTo(this.range.getEndKey(), PartialKey.ROW_COLFAM_COLQUAL) != 0) {
                return RangeInputSplit.getProgress(this.range.getStartKey().getColumnQualifierData(), this.range.getEndKey().getColumnQualifierData(), currentKey.getColumnQualifierData());
            }
        }
        return 0.0f;
    }

    public long getLength() throws IOException {
        return SplitUtils.getRangeLength(this.range);
    }

    public String[] getLocations() throws IOException {
        return Arrays.copyOf(this.locations, this.locations.length);
    }

    public void readFields(DataInput in) throws IOException {
        this.range.readFields(in);
        this.tableName = in.readUTF();
        this.tableId = in.readUTF();
        int numLocs = in.readInt();
        this.locations = new String[numLocs];
        for (int i = 0; i < numLocs; ++i) {
            this.locations[i] = in.readUTF();
        }
        if (in.readBoolean()) {
            this.isolatedScan = in.readBoolean();
        }
        if (in.readBoolean()) {
            this.offline = in.readBoolean();
        }
        if (in.readBoolean()) {
            this.localIterators = in.readBoolean();
        }
        if (in.readBoolean()) {
            this.mockInstance = in.readBoolean();
        }
        if (in.readBoolean()) {
            int numColumns = in.readInt();
            ArrayList<String> columns = new ArrayList<String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                columns.add(in.readUTF());
            }
            this.fetchedColumns = InputConfigurator.deserializeFetchedColumns(columns);
        }
        if (in.readBoolean()) {
            String strAuths = in.readUTF();
            this.auths = new Authorizations(strAuths.getBytes(StandardCharsets.UTF_8));
        }
        if (in.readBoolean()) {
            this.principal = in.readUTF();
        }
        if (in.readBoolean()) {
            int ordinal = in.readInt();
            this.tokenSource = ConfiguratorBase.TokenSource.values()[ordinal];
            switch (this.tokenSource) {
                case INLINE: {
                    String tokenClass = in.readUTF();
                    byte[] base64TokenBytes = in.readUTF().getBytes(StandardCharsets.UTF_8);
                    byte[] tokenBytes = Base64.getDecoder().decode(base64TokenBytes);
                    this.token = AuthenticationToken.AuthenticationTokenSerializer.deserialize(tokenClass, tokenBytes);
                    break;
                }
                case FILE: {
                    this.tokenFile = in.readUTF();
                    break;
                }
                default: {
                    throw new IOException("Cannot parse unknown TokenSource ordinal");
                }
            }
        }
        if (in.readBoolean()) {
            this.instanceName = in.readUTF();
        }
        if (in.readBoolean()) {
            this.zooKeepers = in.readUTF();
        }
        if (in.readBoolean()) {
            int numIterators = in.readInt();
            this.iterators = new ArrayList<IteratorSetting>(numIterators);
            for (int i = 0; i < numIterators; ++i) {
                this.iterators.add(new IteratorSetting(in));
            }
        }
        if (in.readBoolean()) {
            this.level = Level.toLevel((int)in.readInt());
        }
        if (in.readBoolean()) {
            this.samplerConfig = new SamplerConfigurationImpl(in).toSamplerConfiguration();
        }
    }

    public void write(DataOutput out) throws IOException {
        this.range.write(out);
        out.writeUTF(this.tableName);
        out.writeUTF(this.tableId);
        out.writeInt(this.locations.length);
        for (int i = 0; i < this.locations.length; ++i) {
            out.writeUTF(this.locations[i]);
        }
        out.writeBoolean(null != this.isolatedScan);
        if (null != this.isolatedScan) {
            out.writeBoolean(this.isolatedScan);
        }
        out.writeBoolean(null != this.offline);
        if (null != this.offline) {
            out.writeBoolean(this.offline);
        }
        out.writeBoolean(null != this.localIterators);
        if (null != this.localIterators) {
            out.writeBoolean(this.localIterators);
        }
        out.writeBoolean(null != this.mockInstance);
        if (null != this.mockInstance) {
            out.writeBoolean(this.mockInstance);
        }
        out.writeBoolean(null != this.fetchedColumns);
        if (null != this.fetchedColumns) {
            String[] cols = InputConfigurator.serializeColumns(this.fetchedColumns);
            out.writeInt(cols.length);
            for (String col : cols) {
                out.writeUTF(col);
            }
        }
        out.writeBoolean(null != this.auths);
        if (null != this.auths) {
            out.writeUTF(this.auths.serialize());
        }
        out.writeBoolean(null != this.principal);
        if (null != this.principal) {
            out.writeUTF(this.principal);
        }
        out.writeBoolean(null != this.tokenSource);
        if (null != this.tokenSource) {
            out.writeInt(this.tokenSource.ordinal());
            if (null != this.token && null != this.tokenFile) {
                throw new IOException("Cannot use both inline AuthenticationToken and file-based AuthenticationToken");
            }
            if (null != this.token) {
                out.writeUTF(this.token.getClass().getName());
                out.writeUTF(Base64.getEncoder().encodeToString(AuthenticationToken.AuthenticationTokenSerializer.serialize(this.token)));
            } else {
                out.writeUTF(this.tokenFile);
            }
        }
        out.writeBoolean(null != this.instanceName);
        if (null != this.instanceName) {
            out.writeUTF(this.instanceName);
        }
        out.writeBoolean(null != this.zooKeepers);
        if (null != this.zooKeepers) {
            out.writeUTF(this.zooKeepers);
        }
        out.writeBoolean(null != this.iterators);
        if (null != this.iterators) {
            out.writeInt(this.iterators.size());
            for (IteratorSetting iterator : this.iterators) {
                iterator.write(out);
            }
        }
        out.writeBoolean(null != this.level);
        if (null != this.level) {
            out.writeInt(this.level.toInt());
        }
        out.writeBoolean(null != this.samplerConfig);
        if (null != this.samplerConfig) {
            new SamplerConfigurationImpl(this.samplerConfig).write(out);
        }
    }

    @Deprecated
    public String getTable() {
        return this.getTableName();
    }

    public String getTableName() {
        return this.tableName;
    }

    @Deprecated
    public void setTable(String table) {
        this.setTableName(table);
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    @Deprecated
    public Instance getInstance() {
        return this.getInstance(ClientConfiguration.loadDefault());
    }

    public Instance getInstance(ClientConfiguration base) {
        if (null == this.instanceName) {
            return null;
        }
        if (this.isMockInstance().booleanValue()) {
            return DeprecationUtil.makeMockInstance(this.getInstanceName());
        }
        if (null == this.zooKeepers) {
            return null;
        }
        return new ZooKeeperInstance(base.withInstance(this.getInstanceName()).withZkHosts(this.getZooKeepers()));
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getZooKeepers() {
        return this.zooKeepers;
    }

    public void setZooKeepers(String zooKeepers) {
        this.zooKeepers = zooKeepers;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public AuthenticationToken getToken() {
        return this.token;
    }

    public void setToken(AuthenticationToken token) {
        this.tokenSource = ConfiguratorBase.TokenSource.INLINE;
        this.token = token;
    }

    public void setToken(String tokenFile) {
        this.tokenSource = ConfiguratorBase.TokenSource.FILE;
        this.tokenFile = tokenFile;
    }

    public Boolean isOffline() {
        return this.offline;
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public void setLocations(String[] locations) {
        this.locations = Arrays.copyOf(locations, locations.length);
    }

    @Deprecated
    public Boolean isMockInstance() {
        return this.mockInstance;
    }

    @Deprecated
    public void setMockInstance(Boolean mockInstance) {
        this.mockInstance = mockInstance;
    }

    public Boolean isIsolatedScan() {
        return this.isolatedScan;
    }

    public void setIsolatedScan(Boolean isolatedScan) {
        this.isolatedScan = isolatedScan;
    }

    public Authorizations getAuths() {
        return this.auths;
    }

    public void setAuths(Authorizations auths) {
        this.auths = auths;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Boolean usesLocalIterators() {
        return this.localIterators;
    }

    public void setUsesLocalIterators(Boolean localIterators) {
        this.localIterators = localIterators;
    }

    public Set<Pair<Text, Text>> getFetchedColumns() {
        return this.fetchedColumns;
    }

    public void setFetchedColumns(Collection<Pair<Text, Text>> fetchedColumns) {
        this.fetchedColumns = new HashSet<Pair<Text, Text>>();
        for (Pair<Text, Text> columns : fetchedColumns) {
            this.fetchedColumns.add(columns);
        }
    }

    public void setFetchedColumns(Set<Pair<Text, Text>> fetchedColumns) {
        this.fetchedColumns = fetchedColumns;
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public void setIterators(List<IteratorSetting> iterators) {
        this.iterators = iterators;
    }

    public Level getLogLevel() {
        return this.level;
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Range: ").append(this.range);
        sb.append(" Locations: ").append(Arrays.asList(this.locations));
        sb.append(" Table: ").append(this.tableName);
        sb.append(" TableID: ").append(this.tableId);
        sb.append(" InstanceName: ").append(this.instanceName);
        sb.append(" zooKeepers: ").append(this.zooKeepers);
        sb.append(" principal: ").append(this.principal);
        sb.append(" tokenSource: ").append((Object)this.tokenSource);
        sb.append(" authenticationToken: ").append(this.token);
        sb.append(" authenticationTokenFile: ").append(this.tokenFile);
        sb.append(" Authorizations: ").append(this.auths);
        sb.append(" offlineScan: ").append(this.offline);
        sb.append(" mockInstance: ").append(this.mockInstance);
        sb.append(" isolatedScan: ").append(this.isolatedScan);
        sb.append(" localIterators: ").append(this.localIterators);
        sb.append(" fetchColumns: ").append(this.fetchedColumns);
        sb.append(" iterators: ").append(this.iterators);
        sb.append(" logLevel: ").append(this.level);
        sb.append(" samplerConfig: ").append(this.samplerConfig);
        return sb.toString();
    }

    public void setSamplerConfiguration(SamplerConfiguration samplerConfiguration) {
        this.samplerConfig = samplerConfiguration;
    }

    public SamplerConfiguration getSamplerConfiguration() {
        return this.samplerConfig;
    }
}

