/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapreduce.AbstractInputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class InputFormatBase<K, V>
extends AbstractInputFormat<K, V> {
    protected static String getInputTableName(JobContext context) {
        return InputConfigurator.getInputTableName(CLASS, context.getConfiguration());
    }

    public static void setInputTableName(Job job, String tableName) {
        InputConfigurator.setInputTableName(CLASS, job.getConfiguration(), tableName);
    }

    public static void setRanges(Job job, Collection<Range> ranges) {
        InputConfigurator.setRanges(CLASS, job.getConfiguration(), ranges);
    }

    protected static List<Range> getRanges(JobContext context) throws IOException {
        return InputConfigurator.getRanges(CLASS, context.getConfiguration());
    }

    public static void fetchColumns(Job job, Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        InputConfigurator.fetchColumns(CLASS, job.getConfiguration(), columnFamilyColumnQualifierPairs);
    }

    protected static Set<Pair<Text, Text>> getFetchedColumns(JobContext context) {
        return InputConfigurator.getFetchedColumns(CLASS, context.getConfiguration());
    }

    public static void addIterator(Job job, IteratorSetting cfg) {
        InputConfigurator.addIterator(CLASS, job.getConfiguration(), cfg);
    }

    protected static List<IteratorSetting> getIterators(JobContext context) {
        return InputConfigurator.getIterators(CLASS, context.getConfiguration());
    }

    public static void setAutoAdjustRanges(Job job, boolean enableFeature) {
        InputConfigurator.setAutoAdjustRanges(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean getAutoAdjustRanges(JobContext context) {
        return InputConfigurator.getAutoAdjustRanges(CLASS, context.getConfiguration());
    }

    public static void setScanIsolation(Job job, boolean enableFeature) {
        InputConfigurator.setScanIsolation(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean isIsolated(JobContext context) {
        return InputConfigurator.isIsolated(CLASS, context.getConfiguration());
    }

    public static void setLocalIterators(Job job, boolean enableFeature) {
        InputConfigurator.setLocalIterators(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean usesLocalIterators(JobContext context) {
        return InputConfigurator.usesLocalIterators(CLASS, context.getConfiguration());
    }

    public static void setOfflineTableScan(Job job, boolean enableFeature) {
        InputConfigurator.setOfflineTableScan(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean isOfflineScan(JobContext context) {
        return InputConfigurator.isOfflineScan(CLASS, context.getConfiguration());
    }

    public static void setBatchScan(Job job, boolean enableFeature) {
        InputConfigurator.setBatchScan(CLASS, job.getConfiguration(), enableFeature);
    }

    public static boolean isBatchScan(JobContext context) {
        return InputConfigurator.isBatchScan(CLASS, context.getConfiguration());
    }

    public static void setSamplerConfiguration(Job job, SamplerConfiguration samplerConfig) {
        InputConfigurator.setSamplerConfiguration(CLASS, job.getConfiguration(), samplerConfig);
    }

    @Deprecated
    protected static TabletLocator getTabletLocator(JobContext context) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, context.getConfiguration(), InputConfigurator.getInputTableName(CLASS, context.getConfiguration()));
    }

    @Deprecated
    public static class RangeInputSplit
    extends org.apache.accumulo.core.client.mapreduce.RangeInputSplit {
        public RangeInputSplit() {
        }

        public RangeInputSplit(RangeInputSplit other) throws IOException {
            super(other);
        }

        protected RangeInputSplit(String table, Range range, String[] locations) {
            super(table, "", range, locations);
        }

        public RangeInputSplit(String table, String tableId, Range range, String[] locations) {
            super(table, tableId, range, locations);
        }
    }

    protected static abstract class RecordReaderBase<K, V>
    extends AbstractInputFormat.AbstractRecordReader<K, V> {
        protected RecordReaderBase() {
        }

        @Override
        protected List<IteratorSetting> contextIterators(TaskAttemptContext context, String tableName) {
            return InputFormatBase.getIterators((JobContext)context);
        }

        @Deprecated
        protected void setupIterators(TaskAttemptContext context, Scanner scanner) {
            this.setupIterators(context, scanner, null, null);
        }

        @Deprecated
        protected void setupIterators(TaskAttemptContext context, Scanner scanner, org.apache.accumulo.core.client.mapreduce.RangeInputSplit split) {
            this.setupIterators(context, scanner, null, split);
        }
    }
}

