/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletLocatorImpl
extends TabletLocator {
    private static final Logger log = LoggerFactory.getLogger(TabletLocatorImpl.class);
    static final Text MAX_TEXT = new Text();
    static final EndRowComparator endRowComparator = new EndRowComparator();
    protected String tableId;
    protected TabletLocator parent;
    protected TreeMap<Text, TabletLocator.TabletLocation> metaCache = new TreeMap(endRowComparator);
    protected TabletLocationObtainer locationObtainer;
    private TabletServerLockChecker lockChecker;
    protected Text lastTabletRow;
    private TreeSet<KeyExtent> badExtents = new TreeSet();
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();

    public TabletLocatorImpl(String tableId, TabletLocator parent, TabletLocationObtainer tlo, TabletServerLockChecker tslc) {
        this.tableId = tableId;
        this.parent = parent;
        this.locationObtainer = tlo;
        this.lockChecker = tslc;
        this.lastTabletRow = new Text(tableId);
        this.lastTabletRow.append(new byte[]{60}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Mutation> void binMutations(ClientContext context, List<T> mutations, Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, List<T> failures) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Binning {} mutations for table {}", new Object[]{Thread.currentThread().getId(), mutations.size(), this.tableId});
            timer = new OpTimer().start();
        }
        ArrayList<Mutation> notInCache = new ArrayList<Mutation>();
        Text row = new Text();
        LockCheckerSession lcSession = new LockCheckerSession();
        this.rLock.lock();
        try {
            this.processInvalidated(context, lcSession);
            for (Mutation mutation : mutations) {
                row.set(mutation.getRow());
                TabletLocator.TabletLocation tl = this.locateTabletInCache(row);
                if (tl != null && this.addMutation(binnedMutations, mutation, tl, lcSession)) continue;
                notInCache.add(mutation);
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (notInCache.size() > 0) {
            Collections.sort(notInCache, new Comparator<Mutation>(){

                @Override
                public int compare(Mutation o1, Mutation o2) {
                    return WritableComparator.compareBytes((byte[])o1.getRow(), (int)0, (int)o1.getRow().length, (byte[])o2.getRow(), (int)0, (int)o2.getRow().length);
                }
            });
            this.wLock.lock();
            try {
                boolean failed = false;
                for (Mutation mutation : notInCache) {
                    if (failed) {
                        failures.add(mutation);
                        continue;
                    }
                    row.set(mutation.getRow());
                    TabletLocator.TabletLocation tl = this._locateTablet(context, row, false, false, false, lcSession);
                    if (tl != null && this.addMutation(binnedMutations, mutation, tl, lcSession)) continue;
                    failures.add(mutation);
                    failed = true;
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Binned {} mutations for table {} to {} tservers in {}", new Object[]{Thread.currentThread().getId(), mutations.size(), this.tableId, binnedMutations.size(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
    }

    private <T extends Mutation> boolean addMutation(Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, T mutation, TabletLocator.TabletLocation tl, LockCheckerSession lcSession) {
        TabletLocator.TabletServerMutations<T> tsm = binnedMutations.get(tl.tablet_location);
        if (tsm == null) {
            boolean lockHeld;
            boolean bl = lockHeld = lcSession.checkLock(tl) != null;
            if (lockHeld) {
                tsm = new TabletLocator.TabletServerMutations(tl.tablet_session);
                binnedMutations.put(tl.tablet_location, tsm);
            } else {
                return false;
            }
        }
        if (tsm.getSession().equals(tl.tablet_session)) {
            tsm.addMutation(tl.tablet_extent, mutation);
            return true;
        }
        return false;
    }

    private List<Range> binRanges(ClientContext context, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges, boolean useCache, LockCheckerSession lcSession) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArrayList<Range> failures = new ArrayList<Range>();
        ArrayList<TabletLocator.TabletLocation> tabletLocations = new ArrayList<TabletLocator.TabletLocation>();
        boolean lookupFailed = false;
        block0: for (Range range : ranges) {
            tabletLocations.clear();
            Text startRow = range.getStartKey() != null ? range.getStartKey().getRow() : new Text();
            TabletLocator.TabletLocation tl = null;
            if (useCache) {
                tl = lcSession.checkLock(this.locateTabletInCache(startRow));
            } else if (!lookupFailed) {
                tl = this._locateTablet(context, startRow, false, false, false, lcSession);
            }
            if (tl == null) {
                failures.add(range);
                if (useCache) continue;
                lookupFailed = true;
                continue;
            }
            tabletLocations.add(tl);
            while (tl.tablet_extent.getEndRow() != null && !range.afterEndKey(new Key(tl.tablet_extent.getEndRow()).followingKey(PartialKey.ROW))) {
                if (useCache) {
                    Text row = new Text(tl.tablet_extent.getEndRow());
                    row.append(new byte[]{0}, 0, 1);
                    tl = lcSession.checkLock(this.locateTabletInCache(row));
                } else {
                    tl = this._locateTablet(context, tl.tablet_extent.getEndRow(), true, false, false, lcSession);
                }
                if (tl == null) {
                    failures.add(range);
                    if (useCache) continue block0;
                    lookupFailed = true;
                    continue block0;
                }
                tabletLocations.add(tl);
            }
            for (TabletLocator.TabletLocation tl2 : tabletLocations) {
                TabletLocatorImpl.addRange(binnedRanges, tl2.tablet_location, tl2.tablet_extent, range);
            }
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Range> binRanges(ClientContext context, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        List<Range> failures;
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Binning {} ranges for table {}", new Object[]{Thread.currentThread().getId(), ranges.size(), this.tableId});
            timer = new OpTimer().start();
        }
        LockCheckerSession lcSession = new LockCheckerSession();
        this.rLock.lock();
        try {
            this.processInvalidated(context, lcSession);
            failures = this.binRanges(context, ranges, binnedRanges, true, lcSession);
        }
        finally {
            this.rLock.unlock();
        }
        if (failures.size() > 0) {
            Collections.sort(failures);
            this.wLock.lock();
            try {
                failures = this.binRanges(context, failures, binnedRanges, false, lcSession);
            }
            finally {
                this.wLock.unlock();
            }
        }
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Binned {} ranges for table {} to {} tservers in {}", new Object[]{Thread.currentThread().getId(), ranges.size(), this.tableId, binnedRanges.size(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        return failures;
    }

    @Override
    public void invalidateCache(KeyExtent failedExtent) {
        this.wLock.lock();
        try {
            this.badExtents.add(failedExtent);
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace("Invalidated extent={}", (Object)failedExtent);
        }
    }

    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
        this.wLock.lock();
        try {
            this.badExtents.addAll(keySet);
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace("Invalidated {} cache entries for table {}", (Object)keySet.size(), (Object)this.tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(Instance instance, String server) {
        int invalidatedCount = 0;
        this.wLock.lock();
        try {
            for (TabletLocator.TabletLocation cacheEntry : this.metaCache.values()) {
                if (!cacheEntry.tablet_location.equals(server)) continue;
                this.badExtents.add(cacheEntry.tablet_extent);
                ++invalidatedCount;
            }
        }
        finally {
            this.wLock.unlock();
        }
        this.lockChecker.invalidateCache(server);
        if (log.isTraceEnabled()) {
            log.trace("invalidated {} cache entries  table={} server={}", new Object[]{invalidatedCount, this.tableId, server});
        }
    }

    @Override
    public void invalidateCache() {
        int invalidatedCount;
        this.wLock.lock();
        try {
            invalidatedCount = this.metaCache.size();
            this.metaCache.clear();
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace("invalidated all {} cache entries for table={}", (Object)invalidatedCount, (Object)this.tableId);
        }
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(ClientContext context, Text row, boolean skipRow, boolean retry) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation tl;
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Locating tablet  table={} row={} skipRow={} retry={}", new Object[]{Thread.currentThread().getId(), this.tableId, TextUtil.truncate(row), skipRow, retry});
            timer = new OpTimer().start();
        }
        while (true) {
            LockCheckerSession lcSession = new LockCheckerSession();
            tl = this._locateTablet(context, row, skipRow, retry, true, lcSession);
            if (!retry || tl != null) break;
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            if (!log.isTraceEnabled()) continue;
            log.trace("Failed to locate tablet containing row {} in table {}, will retry...", (Object)TextUtil.truncate(row), (Object)this.tableId);
        }
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Located tablet {} at {} in {}", new Object[]{Thread.currentThread().getId(), tl == null ? "null" : tl.tablet_extent, tl == null ? "null" : tl.tablet_location, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        return tl;
    }

    private void lookupTabletLocation(ClientContext context, Text row, boolean retry, LockCheckerSession lcSession) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Text metadataRow = new Text(this.tableId);
        metadataRow.append(new byte[]{59}, 0, 1);
        metadataRow.append(row.getBytes(), 0, row.getLength());
        TabletLocator.TabletLocation ptl = this.parent.locateTablet(context, metadataRow, false, retry);
        if (ptl != null) {
            Text er;
            TabletLocator.TabletLocations locations = this.locationObtainer.lookupTablet(context, ptl, metadataRow, this.lastTabletRow, this.parent);
            while (locations != null && locations.getLocations().isEmpty() && locations.getLocationless().isEmpty() && (er = ptl.tablet_extent.getEndRow()) != null && er.compareTo((BinaryComparable)this.lastTabletRow) < 0 && (ptl = this.parent.locateTablet(context, er, true, retry)) != null) {
                locations = this.locationObtainer.lookupTablet(context, ptl, metadataRow, this.lastTabletRow, this.parent);
            }
            if (locations == null) {
                return;
            }
            Text lastEndRow = null;
            for (TabletLocator.TabletLocation tabletLocation : locations.getLocations()) {
                KeyExtent ke = tabletLocation.tablet_extent;
                TabletLocator.TabletLocation locToCache = lastEndRow != null && ke.getPrevEndRow() != null && ke.getPrevEndRow().equals((Object)lastEndRow) ? new TabletLocator.TabletLocation(new KeyExtent(ke.getTableId(), ke.getEndRow(), lastEndRow), tabletLocation.tablet_location, tabletLocation.tablet_session) : tabletLocation;
                lastEndRow = locToCache.tablet_extent.getEndRow();
                this.updateCache(locToCache, lcSession);
            }
        }
    }

    private void updateCache(TabletLocator.TabletLocation tabletLocation, LockCheckerSession lcSession) {
        if (!tabletLocation.tablet_extent.getTableId().equals(this.tableId)) {
            throw new IllegalStateException("Unexpected extent returned " + this.tableId + "  " + tabletLocation.tablet_extent);
        }
        if (tabletLocation.tablet_location == null) {
            throw new IllegalStateException("Cannot add null locations to cache " + this.tableId + "  " + tabletLocation.tablet_extent);
        }
        if (!tabletLocation.tablet_extent.getTableId().equals(this.tableId)) {
            throw new IllegalStateException("Cannot add other table ids to locations cache " + this.tableId + "  " + tabletLocation.tablet_extent);
        }
        TabletLocatorImpl.removeOverlapping(this.metaCache, tabletLocation.tablet_extent);
        if (lcSession.checkLock(tabletLocation) == null) {
            return;
        }
        Text er = tabletLocation.tablet_extent.getEndRow();
        if (er == null) {
            er = MAX_TEXT;
        }
        this.metaCache.put(er, tabletLocation);
        if (this.badExtents.size() > 0) {
            TabletLocatorImpl.removeOverlapping(this.badExtents, tabletLocation.tablet_extent);
        }
    }

    static void removeOverlapping(TreeMap<Text, TabletLocator.TabletLocation> metaCache, KeyExtent nke) {
        Iterator<Map.Entry<Text, TabletLocator.TabletLocation>> iter = null;
        if (nke.getPrevEndRow() == null) {
            iter = metaCache.entrySet().iterator();
        } else {
            Text row = TabletLocatorImpl.rowAfterPrevRow(nke);
            SortedMap<Text, TabletLocator.TabletLocation> tailMap = metaCache.tailMap(row);
            iter = tailMap.entrySet().iterator();
        }
        while (iter.hasNext()) {
            Map.Entry<Text, TabletLocator.TabletLocation> entry = iter.next();
            KeyExtent ke = entry.getValue().tablet_extent;
            if (TabletLocatorImpl.stopRemoving(nke, ke)) break;
            iter.remove();
        }
    }

    private static boolean stopRemoving(KeyExtent nke, KeyExtent ke) {
        return ke.getPrevEndRow() != null && nke.getEndRow() != null && ke.getPrevEndRow().compareTo((BinaryComparable)nke.getEndRow()) >= 0;
    }

    private static Text rowAfterPrevRow(KeyExtent nke) {
        Text row = new Text(nke.getPrevEndRow());
        row.append(new byte[]{0}, 0, 1);
        return row;
    }

    static void removeOverlapping(TreeSet<KeyExtent> extents, KeyExtent nke) {
        for (KeyExtent overlapping : KeyExtent.findOverlapping(nke, extents)) {
            extents.remove(overlapping);
        }
    }

    private TabletLocator.TabletLocation locateTabletInCache(Text row) {
        KeyExtent ke;
        Map.Entry<Text, TabletLocator.TabletLocation> entry = this.metaCache.ceilingEntry(row);
        if (entry != null && ((ke = entry.getValue().tablet_extent).getPrevEndRow() == null || ke.getPrevEndRow().compareTo((BinaryComparable)row) < 0)) {
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TabletLocator.TabletLocation _locateTablet(ClientContext context, Text row, boolean skipRow, boolean retry, boolean lock, LockCheckerSession lcSession) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation tl;
        if (skipRow) {
            row = new Text(row);
            row.append(new byte[]{0}, 0, 1);
        }
        if (lock) {
            this.rLock.lock();
            try {
                tl = this.processInvalidatedAndCheckLock(context, lcSession, row);
            }
            finally {
                this.rLock.unlock();
            }
        } else {
            tl = this.processInvalidatedAndCheckLock(context, lcSession, row);
        }
        if (tl == null) {
            if (lock) {
                this.wLock.lock();
                try {
                    tl = this.lookupTabletLocationAndCheckLock(context, row, retry, lcSession);
                }
                finally {
                    this.wLock.unlock();
                }
            } else {
                tl = this.lookupTabletLocationAndCheckLock(context, row, retry, lcSession);
            }
        }
        return tl;
    }

    private TabletLocator.TabletLocation lookupTabletLocationAndCheckLock(ClientContext context, Text row, boolean retry, LockCheckerSession lcSession) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        this.lookupTabletLocation(context, row, retry, lcSession);
        return lcSession.checkLock(this.locateTabletInCache(row));
    }

    private TabletLocator.TabletLocation processInvalidatedAndCheckLock(ClientContext context, LockCheckerSession lcSession, Text row) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.processInvalidated(context, lcSession);
        return lcSession.checkLock(this.locateTabletInCache(row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInvalidated(ClientContext context, LockCheckerSession lcSession) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (this.badExtents.size() == 0) {
            return;
        }
        boolean writeLockHeld = this.rwLock.isWriteLockedByCurrentThread();
        try {
            if (!writeLockHeld) {
                this.rLock.unlock();
                this.wLock.lock();
                if (this.badExtents.size() == 0) {
                    return;
                }
            }
            List<Range> lookups = new ArrayList<Range>(this.badExtents.size());
            for (KeyExtent be : this.badExtents) {
                lookups.add(be.toMetadataRange());
                TabletLocatorImpl.removeOverlapping(this.metaCache, be);
            }
            lookups = Range.mergeOverlapping(lookups);
            HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
            this.parent.binRanges(context, lookups, binnedRanges);
            ArrayList tabletServers = new ArrayList(binnedRanges.keySet());
            Collections.shuffle(tabletServers);
            for (String tserver : tabletServers) {
                List<TabletLocator.TabletLocation> locations = this.locationObtainer.lookupTablets(context, tserver, (Map)binnedRanges.get(tserver), this.parent);
                for (TabletLocator.TabletLocation tabletLocation : locations) {
                    this.updateCache(tabletLocation, lcSession);
                }
            }
        }
        finally {
            if (!writeLockHeld) {
                this.rLock.lock();
                this.wLock.unlock();
            }
        }
    }

    protected static void addRange(Map<String, Map<KeyExtent, List<Range>>> binnedRanges, String location, KeyExtent ke, Range range) {
        List<Range> tabletsRanges;
        Map<KeyExtent, List<Range>> tablets = binnedRanges.get(location);
        if (tablets == null) {
            tablets = new HashMap<KeyExtent, List<Range>>();
            binnedRanges.put(location, tablets);
        }
        if ((tabletsRanges = tablets.get(ke)) == null) {
            tabletsRanges = new ArrayList<Range>();
            tablets.put(ke, tabletsRanges);
        }
        tabletsRanges.add(range);
    }

    private class LockCheckerSession {
        private HashSet<Pair<String, String>> okLocks = new HashSet();
        private HashSet<Pair<String, String>> invalidLocks = new HashSet();

        private LockCheckerSession() {
        }

        private TabletLocator.TabletLocation checkLock(TabletLocator.TabletLocation tl) {
            if (tl == null) {
                return null;
            }
            Pair<String, String> lock = new Pair<String, String>(tl.tablet_location, tl.tablet_session);
            if (this.okLocks.contains(lock)) {
                return tl;
            }
            if (this.invalidLocks.contains(lock)) {
                return null;
            }
            if (TabletLocatorImpl.this.lockChecker.isLockHeld(tl.tablet_location, tl.tablet_session)) {
                this.okLocks.add(lock);
                return tl;
            }
            if (log.isTraceEnabled()) {
                log.trace("Tablet server {} {} no longer holds its lock", (Object)tl.tablet_location, (Object)tl.tablet_session);
            }
            this.invalidLocks.add(lock);
            return null;
        }
    }

    public static interface TabletServerLockChecker {
        public boolean isLockHeld(String var1, String var2);

        public void invalidateCache(String var1);
    }

    public static interface TabletLocationObtainer {
        public TabletLocator.TabletLocations lookupTablet(ClientContext var1, TabletLocator.TabletLocation var2, Text var3, Text var4, TabletLocator var5) throws AccumuloSecurityException, AccumuloException;

        public List<TabletLocator.TabletLocation> lookupTablets(ClientContext var1, String var2, Map<KeyExtent, List<Range>> var3, TabletLocator var4) throws AccumuloSecurityException, AccumuloException;
    }

    private static class EndRowComparator
    implements Comparator<Text>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EndRowComparator() {
        }

        @Override
        public int compare(Text o1, Text o2) {
            int ret = o1 == MAX_TEXT ? (o2 == MAX_TEXT ? 0 : 1) : (o2 == MAX_TEXT ? -1 : o1.compareTo((BinaryComparable)o2));
            return ret;
        }
    }
}

