/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchStats;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ArrayOfDoublesSketchToMeans", value="_FUNC_(sketch)", extended="Returns a list of mean values from a given ArrayOfDoublesSketch. The result will be N double values, where N is the number of double values kept in the sketch per key.")
public class ArrayOfDoublesSketchToMeansUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch) {
        if (serializedSketch == null) {
            return null;
        }
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        if (sketch.getRetainedEntries() < 1) {
            return null;
        }
        SummaryStatistics[] summaries = ArrayOfDoublesSketchStats.sketchToSummaryStatistics(sketch);
        ArrayList<Double> means = new ArrayList<Double>(sketch.getNumValues());
        for (int i = 0; i < sketch.getNumValues(); ++i) {
            means.add(summaries[i].getMean());
        }
        return means;
    }
}

