/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ArrayOfDoublesSketchToEstimateAndErrorBounds", value="_FUNC_(sketch)", extended="Returns a unique count estimate and error bounds from a given ArrayOfDoublesSketch. The result will be three double values: estimate of the number of unique keys, lower bound and upper bound. The bounds are given at 95.5% confidence.")
public class ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch) {
        if (serializedSketch == null) {
            return null;
        }
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        return Arrays.asList(sketch.getEstimate(), sketch.getLowerBound(2), sketch.getUpperBound(2));
    }
}

