/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class UnionState
extends GenericUDAFEvaluator.AbstractAggregationBuffer {
    static final float DEFAULT_SAMPLING_PROBABILITY = 1.0f;
    private int nominalEntries_;
    private long seed_;
    private Union union_;

    UnionState() {
    }

    public boolean isInitialized() {
        return this.union_ != null;
    }

    public void init(int nominalEntries, long seed) {
        this.init(nominalEntries, 1.0f, seed);
    }

    public void init(int nominalEntries, float samplingProbability, long seed) {
        this.nominalEntries_ = nominalEntries;
        this.seed_ = seed;
        this.union_ = SetOperation.builder().setNominalEntries(nominalEntries).setP(samplingProbability).setSeed(seed).buildUnion();
    }

    public int getNominalEntries() {
        return this.nominalEntries_;
    }

    public long getSeed() {
        return this.seed_;
    }

    public void update(Memory mem) {
        this.union_.update(mem);
    }

    public void update(Object value, PrimitiveObjectInspector objectInspector) {
        switch (objectInspector.getPrimitiveCategory()) {
            case BINARY: {
                this.union_.update(PrimitiveObjectInspectorUtils.getBinary((Object)value, (PrimitiveObjectInspector)objectInspector).copyBytes());
                return;
            }
            case BYTE: {
                this.union_.update((long)PrimitiveObjectInspectorUtils.getByte((Object)value, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case DOUBLE: {
                this.union_.update(PrimitiveObjectInspectorUtils.getDouble((Object)value, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case FLOAT: {
                this.union_.update((double)PrimitiveObjectInspectorUtils.getFloat((Object)value, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case INT: {
                this.union_.update((long)PrimitiveObjectInspectorUtils.getInt((Object)value, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case LONG: {
                this.union_.update(PrimitiveObjectInspectorUtils.getLong((Object)value, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case STRING: {
                this.union_.update(PrimitiveObjectInspectorUtils.getString((Object)value, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case CHAR: {
                this.union_.update(PrimitiveObjectInspectorUtils.getHiveChar((Object)value, (PrimitiveObjectInspector)objectInspector).getValue());
                return;
            }
            case VARCHAR: {
                this.union_.update(PrimitiveObjectInspectorUtils.getHiveVarchar((Object)value, (PrimitiveObjectInspector)objectInspector).getValue());
                return;
            }
        }
        throw new IllegalArgumentException("Unrecongnized input data type " + value.getClass().getSimpleName() + " category " + objectInspector.getPrimitiveCategory() + ", please use data of the following types: byte, double, float, int, long, char, varchar or string.");
    }

    public Sketch getResult() {
        if (this.union_ == null) {
            return null;
        }
        return this.union_.getResult();
    }

    public void reset() {
        this.union_ = null;
    }
}

