/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.DoublesUnionBuilder;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

class DoublesUnionState
extends GenericUDAFEvaluator.AbstractAggregationBuffer {
    private DoublesUnion union;

    DoublesUnionState() {
    }

    void init(int k) {
        DoublesUnionBuilder unionBuilder = DoublesUnion.builder();
        if (k > 0) {
            unionBuilder.setMaxK(k);
        }
        this.union = unionBuilder.build();
    }

    boolean isInitialized() {
        return this.union != null;
    }

    void update(double value) {
        if (this.union == null) {
            this.union = DoublesUnion.builder().build();
        }
        this.union.update(value);
    }

    void update(Memory serializedSketch) {
        DoublesSketch incomingSketch = DoublesSketch.wrap((Memory)serializedSketch);
        if (this.union == null) {
            this.union = DoublesUnion.heapify((DoublesSketch)incomingSketch);
        } else {
            this.union.update(incomingSketch);
        }
    }

    public DoublesSketch getResult() {
        if (this.union == null) {
            return null;
        }
        return this.union.getResultAndReset();
    }

    void reset() {
        this.union = null;
    }
}

