/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetRank", value="_FUNC_(sketch, value)", extended=" Returns a normalized rank of a given value from a given KllFloatsSketch. The returned rank is an approximation to the fraction of values of the distribution that are less than the given value (mass of the distribution below the given value).")
public class GetRankUDF
extends UDF {
    public Double evaluate(BytesWritable serializedSketch, float value) {
        if (serializedSketch == null) {
            return null;
        }
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        return sketch.getRank(value);
    }
}

