/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.kll.Util;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantiles", value="_FUNC_(sketch, fractions...)", extended="Returns quantile values from a given KllFloatsSketch based on a given list of fractions. The fractions represent normalized ranks, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half).")
public class GetQuantilesUDF
extends UDF {
    public List<Float> evaluate(BytesWritable serializedSketch, Double ... fractions) {
        if (serializedSketch == null) {
            return null;
        }
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        return Util.primitivesToList(sketch.getQuantiles(Util.objectsToPrimitives(fractions)));
    }
}

