/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.timeout;

import org.apache.hive.druid.io.netty.util.Timeout;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.util.DateUtils;
import org.asynchttpclient.util.StringBuilderPool;

public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;

    ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int readTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.readTimeout = readTimeout;
    }

    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        if (this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.unpreciseMillisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Read timeout to ");
            this.appendRemoteAddress(sb);
            String message = sb.append(" after ").append(this.readTimeout).append(" ms").toString();
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
            this.timeoutsHolder.cancel();
        } else {
            this.done.set(false);
            this.timeoutsHolder.startReadTimeout(this);
        }
    }
}

