/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufAllocator;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.handler.stream.ChunkedInput;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.util.Assertions;

public class BodyChunkedInput
implements ChunkedInput<ByteBuf> {
    public static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Body body;
    private final int chunkSize;
    private final long contentLength;
    private boolean endOfInput;
    private long progress = 0L;

    BodyChunkedInput(Body body) {
        this.body = Assertions.assertNotNull(body, "body");
        this.contentLength = body.getContentLength();
        this.chunkSize = this.contentLength <= 0L ? 8192 : (int)Math.min(this.contentLength, 8192L);
    }

    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator alloc) throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuf buffer = alloc.buffer(this.chunkSize);
        Body.BodyState state = this.body.transferTo(buffer);
        this.progress += (long)buffer.writerIndex();
        switch (state) {
            case STOP: {
                this.endOfInput = true;
                return buffer;
            }
            case SUSPEND: {
                buffer.release();
                return null;
            }
            case CONTINUE: {
                return buffer;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
    }

    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    public void close() throws Exception {
        this.body.close();
    }

    public long length() {
        return this.contentLength;
    }

    public long progress() {
        return this.progress;
    }
}

