/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap.longlong;

public class LongUtils {
    public static byte[] highPart(long num) {
        byte[] high48 = new byte[]{(byte)(num >>> 56 & 0xFFL), (byte)(num >>> 48 & 0xFFL), (byte)(num >>> 40 & 0xFFL), (byte)(num >>> 32 & 0xFFL), (byte)(num >>> 24 & 0xFFL), (byte)(num >>> 16 & 0xFFL)};
        return high48;
    }

    public static char lowPart(long num) {
        return (char)num;
    }

    public static long toLong(byte[] high, char low) {
        byte byte6 = (byte)((long)(low >>> 8) & 0xFFL);
        byte byte7 = (byte)low;
        return ((long)high[0] & 0xFFL) << 56 | ((long)high[1] & 0xFFL) << 48 | ((long)high[2] & 0xFFL) << 40 | ((long)high[3] & 0xFFL) << 32 | ((long)high[4] & 0xFFL) << 24 | ((long)high[5] & 0xFFL) << 16 | ((long)byte6 & 0xFFL) << 8 | (long)byte7 & 0xFFL;
    }

    public static byte[] toBDBytes(long v) {
        byte[] work = new byte[8];
        work[7] = (byte)v;
        work[6] = (byte)(v >> 8);
        work[5] = (byte)(v >> 16);
        work[4] = (byte)(v >> 24);
        work[3] = (byte)(v >> 32);
        work[2] = (byte)(v >> 40);
        work[1] = (byte)(v >> 48);
        work[0] = (byte)(v >> 56);
        return work;
    }

    public static long fromBDBytes(byte[] work) {
        return (long)work[0] << 56 | (long)(work[1] & 0xFF) << 48 | (long)(work[2] & 0xFF) << 40 | (long)(work[3] & 0xFF) << 32 | (long)(work[4] & 0xFF) << 24 | (long)(work[5] & 0xFF) << 16 | (long)(work[6] & 0xFF) << 8 | (long)(work[7] & 0xFF);
    }

    public static int compareHigh(byte[] a, byte[] b) {
        return LongUtils.compareTo(a, 0, a.length, b, 0, b.length);
    }

    private static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static long initWithFirst4Byte(int v) {
        return (long)v << 32;
    }

    public static long rightShiftHighPart(long num) {
        return num >>> 16;
    }

    public static long leftShiftHighPart(long num) {
        return num << 16;
    }

    public static int maxLowBitAsInteger() {
        return 65535;
    }

    public static byte[] highPartInPlace(long num, byte[] high48) {
        high48[0] = (byte)(num >>> 56 & 0xFFL);
        high48[1] = (byte)(num >>> 48 & 0xFFL);
        high48[2] = (byte)(num >>> 40 & 0xFFL);
        high48[3] = (byte)(num >>> 32 & 0xFFL);
        high48[4] = (byte)(num >>> 24 & 0xFFL);
        high48[5] = (byte)(num >>> 16 & 0xFFL);
        return high48;
    }
}

