/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap.buffer;

import org.apache.hive.druid.org.roaringbitmap.CharIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.MappeableRunContainer;

final class RawReverseMappeableRunContainerCharIterator
implements CharIterator {
    private int pos;
    private int le;
    private int maxlength;
    private int base;
    private char[] vl;

    RawReverseMappeableRunContainerCharIterator(MappeableRunContainer p) {
        this.wrap(p);
    }

    @Override
    public CharIterator clone() {
        try {
            return (CharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private char getLength(int index) {
        return this.vl[2 * index + 1];
    }

    private char getValue(int index) {
        return this.vl[2 * index];
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public char next() {
        char ans = (char)(this.base + this.maxlength - this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = this.getLength(this.pos);
                this.base = this.getValue(this.pos);
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.maxlength - this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = this.getLength(this.pos);
                this.base = this.getValue(this.pos);
            }
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    private void wrap(MappeableRunContainer p) {
        MappeableRunContainer parent = p;
        if (!parent.isArrayBacked()) {
            throw new RuntimeException("internal error");
        }
        this.vl = parent.valueslength.array();
        this.pos = parent.nbrruns - 1;
        this.le = 0;
        if (this.pos >= 0) {
            this.maxlength = this.getLength(this.pos);
            this.base = this.getValue(this.pos);
        }
    }
}

