/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap.buffer;

import java.nio.CharBuffer;
import org.apache.hive.druid.org.roaringbitmap.ContainerBatchIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.MappeableArrayContainer;

public final class ArrayBatchIterator
implements ContainerBatchIterator {
    private int index = 0;
    private MappeableArrayContainer array;

    public ArrayBatchIterator(MappeableArrayContainer array) {
        this.wrap(array);
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        CharBuffer data = this.array.content;
        while (consumed < buffer.length && this.index < this.array.getCardinality()) {
            buffer[consumed++] = key + data.get(this.index++);
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void releaseContainer() {
        this.array = null;
    }

    public void wrap(MappeableArrayContainer array) {
        this.array = array;
        this.index = 0;
    }
}

