/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap;

import org.apache.hive.druid.org.roaringbitmap.ContainerBatchIterator;
import org.apache.hive.druid.org.roaringbitmap.RunContainer;

public final class RunBatchIterator
implements ContainerBatchIterator {
    private RunContainer runs;
    private int run = 0;
    private int cursor = 0;

    public RunBatchIterator(RunContainer runs) {
        this.wrap(runs);
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        do {
            char runStart = this.runs.getValue(this.run);
            char runLength = this.runs.getLength(this.run);
            int chunkStart = runStart + this.cursor;
            int chunkEnd = chunkStart + Math.min(runLength - this.cursor, buffer.length - consumed - 1);
            int chunk = chunkEnd - chunkStart + 1;
            for (int i = 0; i < chunk; ++i) {
                buffer[consumed + i] = key + chunkStart + i;
            }
            consumed += chunk;
            if (runStart + runLength == chunkEnd) {
                ++this.run;
                this.cursor = 0;
                continue;
            }
            this.cursor += chunk;
        } while (consumed < buffer.length && this.run != this.runs.numberOfRuns());
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.run < this.runs.numberOfRuns();
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void releaseContainer() {
        this.runs = null;
    }

    void wrap(RunContainer runs) {
        this.runs = runs;
        this.run = 0;
        this.cursor = 0;
    }
}

