/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.utils;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;

public final class CollectionUtils {
    public static <E> Collection<E> createLazyCollectionFromStream(final Supplier<Stream<E>> sequentialStreamSupplier, final int size) {
        return new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                return ((Stream)sequentialStreamSupplier.get()).iterator();
            }

            @Override
            public Spliterator<E> spliterator() {
                return ((Stream)sequentialStreamSupplier.get()).spliterator();
            }

            @Override
            public Stream<E> stream() {
                return (Stream)sequentialStreamSupplier.get();
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)((Stream)sequentialStreamSupplier.get()).parallel();
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator, Iterable<E> elements) {
        TreeSet<? super E> set = new TreeSet<E>(comparator);
        Iterables.addAll(set, elements);
        return set;
    }

    public static <K, V, V2> Map<K, V2> mapValues(Map<K, V> map, Function<V, V2> valueMapper) {
        HashMap result = Maps.newHashMapWithExpectedSize(map.size());
        map.forEach((k, v) -> result.put(k, valueMapper.apply(v)));
        return result;
    }

    public static <K, V, K2> Map<K2, V> mapKeys(Map<K, V> map, Function<K, K2> keyMapper) {
        HashMap result = Maps.newHashMapWithExpectedSize(map.size());
        map.forEach((k, v) -> {
            Object k2 = keyMapper.apply(k);
            if (result.putIfAbsent(k2, v) != null) {
                throw new ISE("Conflicting key[%s] calculated via keyMapper for original key[%s]", k2, k);
            }
        });
        return result;
    }

    public static boolean isNullOrEmpty(@Nullable List<?> list) {
        return list == null || list.isEmpty();
    }

    private CollectionUtils() {
    }
}

