/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecFactory;

public class NumberedOverwritingShardSpecFactory
implements ShardSpecFactory {
    private final int startRootPartitionId;
    private final int endRootPartitionId;
    private final short minorVersion;

    @JsonCreator
    public NumberedOverwritingShardSpecFactory(@JsonProperty(value="startRootPartitionId") int startRootPartitionId, @JsonProperty(value="endRootPartitionId") int endRootPartitionId, @JsonProperty(value="minorVersion") short minorVersion) {
        this.startRootPartitionId = startRootPartitionId;
        this.endRootPartitionId = endRootPartitionId;
        this.minorVersion = minorVersion;
    }

    @JsonProperty
    public int getStartRootPartitionId() {
        return this.startRootPartitionId;
    }

    @JsonProperty
    public int getEndRootPartitionId() {
        return this.endRootPartitionId;
    }

    @JsonProperty
    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public ShardSpec create(ObjectMapper objectMapper, @Nullable ShardSpec specOfPreviousMaxPartitionId) {
        return new NumberedOverwriteShardSpec(specOfPreviousMaxPartitionId == null ? 32768 : specOfPreviousMaxPartitionId.getPartitionNum() + 1, this.startRootPartitionId, this.endRootPartitionId, this.minorVersion);
    }

    @Override
    public ShardSpec create(ObjectMapper objectMapper, int partitionId) {
        return new NumberedOverwriteShardSpec(partitionId, this.startRootPartitionId, this.endRootPartitionId, this.minorVersion);
    }

    @Override
    public Class<? extends ShardSpec> getShardSpecClass() {
        return NumberedOverwriteShardSpec.class;
    }
}

