/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecFactory;

public class HashBasedNumberedShardSpecFactory
implements ShardSpecFactory {
    @Nullable
    private final List<String> partitionDimensions;
    private final int numPartitions;

    @JsonCreator
    public HashBasedNumberedShardSpecFactory(@JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JsonProperty(value="numPartitions") int numPartitions) {
        this.partitionDimensions = partitionDimensions;
        this.numPartitions = numPartitions;
    }

    @Nullable
    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @JsonProperty
    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public ShardSpec create(ObjectMapper objectMapper, @Nullable ShardSpec specOfPreviousMaxPartitionId) {
        HashBasedNumberedShardSpec prevSpec = (HashBasedNumberedShardSpec)specOfPreviousMaxPartitionId;
        return new HashBasedNumberedShardSpec(prevSpec == null ? 0 : prevSpec.getPartitionNum() + 1, this.numPartitions, this.partitionDimensions, objectMapper);
    }

    @Override
    public ShardSpec create(ObjectMapper objectMapper, int partitionId) {
        return new HashBasedNumberedShardSpec(partitionId, this.numPartitions, this.partitionDimensions, objectMapper);
    }

    @Override
    public Class<? extends ShardSpec> getShardSpecClass() {
        return HashBasedNumberedShardSpec.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashBasedNumberedShardSpecFactory that = (HashBasedNumberedShardSpecFactory)o;
        return this.numPartitions == that.numPartitions && Objects.equals(this.partitionDimensions, that.partitionDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.partitionDimensions, this.numPartitions);
    }
}

