/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.guice.Hdfs;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class HdfsDataSegmentKiller
implements DataSegmentKiller {
    private static final EmittingLogger log = new EmittingLogger(HdfsDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final Configuration config;
    private final Path storageDirectory;

    @Inject
    public HdfsDataSegmentKiller(@Hdfs Configuration config, HdfsDataSegmentPusherConfig pusherConfig) {
        this.config = config;
        this.storageDirectory = new Path(pusherConfig.getStorageDirectory());
    }

    private static Path getPath(DataSegment segment) {
        return new Path(String.valueOf(segment.getLoadSpec().get(PATH_KEY)));
    }

    @Override
    public void kill(DataSegment segment) throws SegmentLoadingException {
        Path segmentPath = HdfsDataSegmentKiller.getPath(segment);
        log.info("Killing segment[%s] mapped to path[%s]", segment.getId(), segmentPath);
        try {
            String filename = segmentPath.getName();
            FileSystem fs = segmentPath.getFileSystem(this.config);
            if (!filename.endsWith(".zip")) {
                throw new SegmentLoadingException("Unknown file type[%s]", segmentPath);
            }
            if (!fs.exists(segmentPath)) {
                log.warn("Segment path [%s] does not exist", segmentPath);
                return;
            }
            String[] zipParts = filename.split("_");
            Path descriptorPath = new Path(segmentPath.getParent(), "descriptor.json");
            if (zipParts.length > 1) {
                Preconditions.checkState(zipParts.length <= 3 && StringUtils.isNumeric((String)zipParts[0]) && "index.zip".equals(zipParts[zipParts.length - 1]), "Unexpected segmentPath format [%s]", segmentPath);
                descriptorPath = new Path(segmentPath.getParent(), org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils.format("%s_%sdescriptor.json", zipParts[0], zipParts.length == 2 ? "" : zipParts[1] + "_"));
            }
            if (!fs.delete(segmentPath, false)) {
                throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", segmentPath.toString());
            }
            fs.delete(descriptorPath, false);
            this.removeEmptyParentDirectories(fs, segmentPath, zipParts.length > 1 ? 2 : 3);
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, "Unable to kill segment", new Object[0]);
        }
    }

    @Override
    public void killAll() throws IOException {
        log.info("Deleting all segment files from hdfs dir [%s].", this.storageDirectory.toUri().toString());
        FileSystem fs = this.storageDirectory.getFileSystem(this.config);
        fs.delete(this.storageDirectory, true);
    }

    private void removeEmptyParentDirectories(FileSystem fs, Path segmentPath, int depth) {
        Path path = segmentPath;
        try {
            for (int i = 1; i <= depth && fs.listStatus(path = path.getParent()).length == 0 && fs.delete(path, false); ++i) {
            }
        }
        catch (Exception e) {
            log.makeAlert(e, "uncaught exception during segment killer", new Object[0]).emit();
        }
    }
}

