/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.hive.druid.org.apache.druid.server.metrics.TaskCountStatsProvider;

public class TaskCountStatsMonitor
extends AbstractMonitor {
    private final TaskCountStatsProvider statsProvider;

    @Inject
    public TaskCountStatsMonitor(TaskCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.emit(emitter, "task/success/count", this.statsProvider.getSuccessfulTaskCount());
        this.emit(emitter, "task/failed/count", this.statsProvider.getFailedTaskCount());
        this.emit(emitter, "task/running/count", this.statsProvider.getRunningTaskCount());
        this.emit(emitter, "task/pending/count", this.statsProvider.getPendingTaskCount());
        this.emit(emitter, "task/waiting/count", this.statsProvider.getWaitingTaskCount());
        return true;
    }

    private void emit(ServiceEmitter emitter, String key, Map<String, Long> counts) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        if (counts != null) {
            counts.forEach((k, v) -> {
                builder.setDimension("dataSource", k);
                emitter.emit(builder.build(key, (Number)v));
            });
        }
    }
}

