/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.hive.druid.org.apache.druid.server.metrics.QueryCountStatsProvider;

public class QueryCountStatsMonitor
extends AbstractMonitor {
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final QueryCountStatsProvider statsProvider;

    @Inject
    public QueryCountStatsMonitor(QueryCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        long interruptedQueryCount;
        long failedQueryCount;
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        long successfulQueryCount = this.statsProvider.getSuccessfulQueryCount();
        Map<String, Long> diff = this.keyedDiff.to("queryCountStats", ImmutableMap.of("query/count", successfulQueryCount + (failedQueryCount = this.statsProvider.getFailedQueryCount()) + (interruptedQueryCount = this.statsProvider.getInterruptedQueryCount()), "query/success/count", successfulQueryCount, "query/failed/count", failedQueryCount, "query/interrupted/count", interruptedQueryCount));
        if (diff != null) {
            for (Map.Entry<String, Long> diffEntry : diff.entrySet()) {
                emitter.emit(builder.build(diffEntry.getKey(), diffEntry.getValue()));
            }
        }
        return true;
    }
}

