/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.hive.druid.org.apache.druid.server.metrics.EventReceiverFirehoseMetric;
import org.apache.hive.druid.org.apache.druid.server.metrics.EventReceiverFirehoseRegister;
import org.apache.hive.druid.org.apache.druid.server.metrics.MonitorsConfig;

public class EventReceiverFirehoseMonitor
extends AbstractMonitor {
    private final EventReceiverFirehoseRegister register;
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final Map<String, String[]> dimensions;

    @Inject
    public EventReceiverFirehoseMonitor(EventReceiverFirehoseRegister eventReceiverFirehoseRegister, Properties props) {
        this.register = eventReceiverFirehoseRegister;
        this.dimensions = MonitorsConfig.extractDimensions(props, Lists.newArrayList("dataSource", "taskId", "taskType"));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        for (Map.Entry<String, EventReceiverFirehoseMetric> entry : this.register.getMetrics()) {
            String serviceName = entry.getKey();
            EventReceiverFirehoseMetric metric = entry.getValue();
            ServiceMetricEvent.Builder builder = this.createEventBuilder(serviceName).setDimension("bufferCapacity", String.valueOf(metric.getCapacity()));
            emitter.emit(builder.build("ingest/events/buffered", metric.getCurrentBufferSize()));
            Map<String, Long> diff = this.keyedDiff.to(serviceName, ImmutableMap.of("ingest/bytes/received", metric.getBytesReceived()));
            if (diff == null) continue;
            ServiceMetricEvent.Builder eventBuilder = this.createEventBuilder(serviceName);
            for (Map.Entry<String, Long> diffEntry : diff.entrySet()) {
                emitter.emit(eventBuilder.build(diffEntry.getKey(), diffEntry.getValue()));
            }
        }
        return true;
    }

    private ServiceMetricEvent.Builder createEventBuilder(String serviceName) {
        ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder().setDimension("serviceName", serviceName);
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        return builder;
    }
}

