/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.log;

import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.server.RequestLogLine;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLoggerProvider;

@JsonTypeName(value="filtered")
public class FilteredRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(FilteredRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private RequestLoggerProvider delegate = null;
    @JsonProperty
    private long queryTimeThresholdMs = 0L;
    @JsonProperty
    private long sqlQueryTimeThresholdMs = 0L;
    @JsonProperty
    private List<String> mutedQueryTypes = ImmutableList.of();

    public RequestLogger get() {
        FilteredRequestLogger logger = new FilteredRequestLogger((RequestLogger)this.delegate.get(), this.queryTimeThresholdMs, this.sqlQueryTimeThresholdMs, this.mutedQueryTypes);
        log.debug(new Exception("Stack trace"), "Creating %s at", logger);
        return logger;
    }

    public static class FilteredRequestLogger
    implements RequestLogger {
        private final RequestLogger logger;
        private final long queryTimeThresholdMs;
        private final long sqlQueryTimeThresholdMs;
        private final List<String> mutedQueryTypes;

        public FilteredRequestLogger(RequestLogger logger, long queryTimeThresholdMs, long sqlQueryTimeThresholdMs, List<String> mutedQueryTypes) {
            this.logger = logger;
            this.queryTimeThresholdMs = queryTimeThresholdMs;
            this.sqlQueryTimeThresholdMs = sqlQueryTimeThresholdMs;
            this.mutedQueryTypes = mutedQueryTypes;
        }

        public long getQueryTimeThresholdMs() {
            return this.queryTimeThresholdMs;
        }

        public RequestLogger getDelegate() {
            return this.logger;
        }

        @Override
        @LifecycleStart
        public void start() throws Exception {
            this.logger.start();
        }

        @Override
        @LifecycleStop
        public void stop() {
            this.logger.stop();
        }

        @Override
        public void logNativeQuery(RequestLogLine requestLogLine) throws IOException {
            Object queryTime = requestLogLine.getQueryStats().getStats().get("query/time");
            if (queryTime != null && ((Number)queryTime).longValue() >= this.queryTimeThresholdMs) {
                Query query = requestLogLine.getQuery();
                if (query != null && this.mutedQueryTypes.contains(query.getType())) {
                    return;
                }
                this.logger.logNativeQuery(requestLogLine);
            }
        }

        @Override
        public void logSqlQuery(RequestLogLine requestLogLine) throws IOException {
            Object sqlQueryTime = requestLogLine.getQueryStats().getStats().get("sqlQuery/time");
            if (sqlQueryTime != null && ((Number)sqlQueryTime).longValue() >= this.sqlQueryTimeThresholdMs) {
                Query query = requestLogLine.getQuery();
                if (query != null && this.mutedQueryTypes.contains(query.getType())) {
                    return;
                }
                this.logger.logSqlQuery(requestLogLine);
            }
        }

        public String toString() {
            return "FilteredRequestLogger{logger=" + this.logger + ", queryTimeThresholdMs=" + this.queryTimeThresholdMs + ", sqlQueryTimeThresholdMs=" + this.sqlQueryTimeThresholdMs + ", mutedQueryTypes=" + this.mutedQueryTypes + '}';
        }
    }
}

