/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.initialization.jetty;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.ServletFilterHolder;

public class ResponseHeaderFilterHolder
implements ServletFilterHolder {
    private final String path;
    private final Map<String, String> headers;

    public ResponseHeaderFilterHolder(String path, Map<String, String> headers) {
        this.path = path;
        this.headers = headers;
    }

    @Override
    public Filter getFilter() {
        return new ResponseHeaderFilter();
    }

    @Override
    public Class<? extends Filter> getFilterClass() {
        return ResponseHeaderFilter.class;
    }

    @Override
    public Map<String, String> getInitParameters() {
        return ImmutableMap.copyOf(this.headers);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    private static class ResponseHeaderFilter
    implements Filter {
        private volatile FilterConfig config;

        private ResponseHeaderFilter() {
        }

        public void init(FilterConfig filterConfig) {
            this.config = filterConfig;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.config != null) {
                Enumeration it = this.config.getInitParameterNames();
                while (it.hasMoreElements()) {
                    String key = (String)it.nextElement();
                    ((HttpServletResponse)response).setHeader(key, this.config.getInitParameter(key));
                }
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

