/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.org.apache.druid.client.DruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.InventoryView;
import org.apache.hive.druid.org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

@Path(value="/druid/coordinator/v1/tiers")
@ResourceFilters(value={StateResourceFilter.class})
public class TiersResource {
    private final InventoryView serverInventoryView;

    @Inject
    public TiersResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTiers(@QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (simple != null) {
            HashMap<String, Map> metadata = new HashMap<String, Map>();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                Map tierMetadata = metadata.computeIfAbsent(druidServer.getTier(), tier -> new EnumMap(TierMetadataKeys.class));
                tierMetadata.merge(TierMetadataKeys.currSize, druidServer.getCurrSize(), Long::sum);
                tierMetadata.merge(TierMetadataKeys.maxSize, druidServer.getMaxSize(), Long::sum);
            }
            return builder.entity(metadata).build();
        }
        Set tiers = this.serverInventoryView.getInventory().stream().map(DruidServer::getTier).collect(Collectors.toSet());
        return builder.entity(tiers).build();
    }

    @GET
    @Path(value="/{tierName}")
    @Produces(value={"application/json"})
    public Response getTierDataSources(@PathParam(value="tierName") String tierName, @QueryParam(value="simple") String simple) {
        if (simple != null) {
            HashMap<String, Map> tierToStatsPerInterval = new HashMap<String, Map>();
            for (DruidServer druidServer2 : this.serverInventoryView.getInventory()) {
                if (!druidServer2.getTier().equalsIgnoreCase(tierName)) continue;
                for (DataSegment dataSegment : druidServer2.iterateAllSegments()) {
                    Map properties = tierToStatsPerInterval.computeIfAbsent(dataSegment.getDataSource(), dsName -> new HashMap()).computeIfAbsent(dataSegment.getInterval(), interval -> new EnumMap(IntervalProperties.class));
                    properties.merge(IntervalProperties.size, dataSegment.getSize(), (a, b) -> (Long)a + (Long)b);
                    properties.merge(IntervalProperties.count, 1, (a, b) -> (Integer)a + (Integer)b);
                }
            }
            return Response.ok(tierToStatsPerInterval).build();
        }
        Set retVal = this.serverInventoryView.getInventory().stream().filter(druidServer -> druidServer.getTier().equalsIgnoreCase(tierName)).flatMap(druidServer -> druidServer.getDataSources().stream().map(DruidDataSource::getName)).collect(Collectors.toSet());
        return Response.ok(retVal).build();
    }

    private static enum IntervalProperties {
        size,
        count;

    }

    private static enum TierMetadataKeys {
        currSize,
        maxSize;

    }
}

