/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.hive.druid.org.apache.druid.client.DruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.InventoryView;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizationUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;

public interface InventoryViewUtils {
    public static Comparator<ImmutableDruidDataSource> comparingByName() {
        return Comparator.comparing(ImmutableDruidDataSource::getName);
    }

    public static SortedSet<ImmutableDruidDataSource> getDataSources(InventoryView serverInventoryView) {
        return serverInventoryView.getInventory().stream().flatMap(server -> server.getDataSources().stream()).map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toCollection(() -> new TreeSet<ImmutableDruidDataSource>(InventoryViewUtils.comparingByName())));
    }

    public static SortedSet<ImmutableDruidDataSource> getSecuredDataSources(HttpServletRequest request, InventoryView inventoryView, AuthorizerMapper authorizerMapper) {
        if (authorizerMapper == null) {
            throw new ISE("No authorization mapper found", new Object[0]);
        }
        Iterable<ImmutableDruidDataSource> filteredResources = AuthorizationUtils.filterAuthorizedResources(request, InventoryViewUtils.getDataSources(inventoryView), datasource -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply(datasource.getName())), authorizerMapper);
        TreeSet<ImmutableDruidDataSource> set = new TreeSet<ImmutableDruidDataSource>(InventoryViewUtils.comparingByName());
        filteredResources.forEach(set::add);
        return Collections.unmodifiableSortedSet(set);
    }
}

