/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rules;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;

public class PeriodBroadcastDistributionRule
extends BroadcastDistributionRule {
    static final String TYPE = "broadcastByPeriod";
    private static final boolean DEFAULT_INCLUDE_FUTURE = true;
    private final Period period;
    private final boolean includeFuture;
    private final List<String> colocatedDataSources;

    @JsonCreator
    public PeriodBroadcastDistributionRule(@JsonProperty(value="period") Period period, @JsonProperty(value="includeFuture") Boolean includeFuture, @JsonProperty(value="colocatedDataSources") List<String> colocatedDataSources) {
        this.period = period;
        this.includeFuture = includeFuture == null ? true : includeFuture;
        this.colocatedDataSources = colocatedDataSources;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonProperty
    public List<String> getColocatedDataSources() {
        return this.colocatedDataSources;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.period, interval, referenceTimestamp, this.includeFuture);
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isIncludeFuture() {
        return this.includeFuture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PeriodBroadcastDistributionRule that = (PeriodBroadcastDistributionRule)o;
        if (!Objects.equals(this.period, that.period)) {
            return false;
        }
        if (this.includeFuture != that.includeFuture) {
            return false;
        }
        return Objects.equals(this.colocatedDataSources, that.colocatedDataSources);
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.period, this.colocatedDataSources);
    }
}

