/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class ForeverLoadRule
extends LoadRule {
    private final Map<String, Integer> tieredReplicants;

    @JsonCreator
    public ForeverLoadRule(@JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants) {
        this.tieredReplicants = tieredReplicants == null ? ImmutableMap.of("_default_tier", 2) : tieredReplicants;
        ForeverLoadRule.validateTieredReplicants(this.tieredReplicants);
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadForever";
    }

    @Override
    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @Override
    public int getNumReplicants(String tier) {
        Integer retVal = this.tieredReplicants.get(tier);
        return retVal == null ? 0 : retVal;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return true;
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return true;
    }
}

