/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;

public class DruidCoordinatorRuleRunner
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorRuleRunner.class);
    private static final int MAX_MISSING_RULES = 10;
    private final ReplicationThrottler replicatorThrottler;
    private final DruidCoordinator coordinator;

    public DruidCoordinatorRuleRunner(DruidCoordinator coordinator) {
        this(new ReplicationThrottler(coordinator.getDynamicConfigs().getReplicationThrottleLimit(), coordinator.getDynamicConfigs().getReplicantLifetime()), coordinator);
    }

    public DruidCoordinatorRuleRunner(ReplicationThrottler replicatorThrottler, DruidCoordinator coordinator) {
        this.replicatorThrottler = replicatorThrottler;
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        this.replicatorThrottler.updateParams(this.coordinator.getDynamicConfigs().getReplicationThrottleLimit(), this.coordinator.getDynamicConfigs().getReplicantLifetime());
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Uh... I have no servers. Not assigning anything...", new Object[0]);
            return params;
        }
        ImmutableSet<SegmentId> overshadowed = params.getDataSourcesSnapshot().getOvershadowedSegments();
        for (String tier : cluster.getTierNames()) {
            this.replicatorThrottler.updateReplicationState(tier);
        }
        DruidCoordinatorRuntimeParams paramsWithReplicationManager = params.buildFromExistingWithoutSegmentsMetadata().withReplicationManager(this.replicatorThrottler).build();
        DateTime now = DateTimes.nowUtc();
        MetadataRuleManager databaseRuleManager = paramsWithReplicationManager.getDatabaseRuleManager();
        ArrayList<SegmentId> segmentsWithMissingRules = Lists.newArrayListWithCapacity(10);
        int missingRules = 0;
        for (DataSegment segment : params.getUsedSegments()) {
            if (overshadowed.contains(segment.getId())) continue;
            List<Rule> rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                stats.accumulate(rule.run(this.coordinator, paramsWithReplicationManager, segment));
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            if (segmentsWithMissingRules.size() < 10) {
                segmentsWithMissingRules.add(segment.getId());
            }
            ++missingRules;
        }
        if (!segmentsWithMissingRules.isEmpty()) {
            log.makeAlert("Unable to find matching rules!", new Object[0]).addData("segmentsWithMissingRulesCount", missingRules).addData("segmentsWithMissingRules", segmentsWithMissingRules).emit();
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

