/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.org.apache.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;

public class DruidCoordinatorCleanupOvershadowed
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupOvershadowed(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (!params.coordinatorIsLeadingEnoughTimeToMarkAsUnusedOvershadowedSegements()) {
            return params;
        }
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        HashMap<String, VersionedIntervalTimeline> timelines = new HashMap<String, VersionedIntervalTimeline>();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                ImmutableDruidServer server = serverHolder.getServer();
                for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                    VersionedIntervalTimeline timeline = timelines.computeIfAbsent(dataSource.getName(), dsName -> new VersionedIntervalTimeline(Comparator.naturalOrder()));
                    VersionedIntervalTimeline.addSegments(timeline, dataSource.getSegments().iterator());
                }
            }
        }
        for (DataSegment dataSegment : params.getUsedSegments()) {
            VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null || !timeline.isOvershadowed(dataSegment.getInterval(), dataSegment.getVersion(), dataSegment)) continue;
            this.coordinator.markSegmentAsUnused(dataSegment);
            stats.addToGlobalStat("overShadowedCount", 1L);
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

