/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestNoop;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@Deprecated
public class CuratorLoadQueuePeon
extends LoadQueuePeon {
    private static final EmittingLogger log = new EmittingLogger(CuratorLoadQueuePeon.class);
    private static final int DROP = 0;
    private static final int LOAD = 1;
    private final CuratorFramework curator;
    private final String basePath;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService processingExecutor;
    private final ExecutorService callBackExecutor;
    private final DruidCoordinatorConfig config;
    private final AtomicLong queuedSize = new AtomicLong(0L);
    private final AtomicInteger failedAssignCount = new AtomicInteger(0);
    private final ConcurrentSkipListMap<DataSegment, SegmentHolder> segmentsToLoad = new ConcurrentSkipListMap(DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
    private final ConcurrentSkipListMap<DataSegment, SegmentHolder> segmentsToDrop = new ConcurrentSkipListMap(DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
    private final ConcurrentSkipListSet<DataSegment> segmentsMarkedToDrop = new ConcurrentSkipListSet<DataSegment>(DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);

    CuratorLoadQueuePeon(CuratorFramework curator, String basePath, ObjectMapper jsonMapper, ScheduledExecutorService processingExecutor, ExecutorService callbackExecutor, DruidCoordinatorConfig config) {
        this.curator = curator;
        this.basePath = basePath;
        this.jsonMapper = jsonMapper;
        this.callBackExecutor = callbackExecutor;
        this.processingExecutor = processingExecutor;
        this.config = config;
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsToLoad() {
        return this.segmentsToLoad.keySet();
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsToDrop() {
        return this.segmentsToDrop.keySet();
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsMarkedToDrop() {
        return this.segmentsMarkedToDrop;
    }

    @Override
    public long getLoadQueueSize() {
        return this.queuedSize.get();
    }

    @Override
    public int getAndResetFailedAssignCount() {
        return this.failedAssignCount.getAndSet(0);
    }

    @Override
    public int getNumberOfSegmentsInQueue() {
        return this.segmentsToLoad.size();
    }

    @Override
    public void loadSegment(DataSegment segment, @Nullable LoadPeonCallback callback) {
        SegmentHolder segmentHolder = new SegmentHolder(segment, 1, Collections.singletonList(callback));
        SegmentHolder existingHolder = this.segmentsToLoad.putIfAbsent(segment, segmentHolder);
        if (existingHolder != null) {
            existingHolder.addCallback(callback);
            return;
        }
        log.debug("Asking server peon[%s] to load segment[%s]", this.basePath, segment.getId());
        this.queuedSize.addAndGet(segment.getSize());
        this.processingExecutor.submit(new SegmentChangeProcessor(segmentHolder));
    }

    @Override
    public void dropSegment(DataSegment segment, @Nullable LoadPeonCallback callback) {
        SegmentHolder segmentHolder = new SegmentHolder(segment, 0, Collections.singletonList(callback));
        SegmentHolder existingHolder = this.segmentsToDrop.putIfAbsent(segment, segmentHolder);
        if (existingHolder != null) {
            existingHolder.addCallback(callback);
            return;
        }
        log.debug("Asking server peon[%s] to drop segment[%s]", this.basePath, segment.getId());
        this.processingExecutor.submit(new SegmentChangeProcessor(segmentHolder));
    }

    @Override
    public void markSegmentToDrop(DataSegment dataSegment) {
        this.segmentsMarkedToDrop.add(dataSegment);
    }

    @Override
    public void unmarkSegmentToDrop(DataSegment dataSegment) {
        this.segmentsMarkedToDrop.remove(dataSegment);
    }

    private void actionCompleted(SegmentHolder segmentHolder) {
        switch (segmentHolder.getType()) {
            case 1: {
                this.segmentsToLoad.remove(segmentHolder.getSegment());
                this.queuedSize.addAndGet(-segmentHolder.getSegmentSize());
                break;
            }
            case 0: {
                this.segmentsToDrop.remove(segmentHolder.getSegment());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.executeCallbacks(segmentHolder);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (SegmentHolder holder : this.segmentsToDrop.values()) {
            this.executeCallbacks(holder);
        }
        this.segmentsToDrop.clear();
        for (SegmentHolder holder : this.segmentsToLoad.values()) {
            this.executeCallbacks(holder);
        }
        this.segmentsToLoad.clear();
        this.queuedSize.set(0L);
        this.failedAssignCount.set(0);
    }

    private void entryRemoved(SegmentHolder segmentHolder, String path) {
        if (!ZKPaths.getNodeFromPath((String)path).equals(segmentHolder.getSegmentIdentifier())) {
            log.warn("Server[%s] entry [%s] was removed even though it's not what is currently loading[%s]", this.basePath, path, segmentHolder);
            return;
        }
        this.actionCompleted(segmentHolder);
        log.debug("Server[%s] done processing %s of segment [%s]", this.basePath, segmentHolder.getType() == 1 ? "load" : "drop", path);
    }

    private void failAssign(SegmentHolder segmentHolder) {
        this.failAssign(segmentHolder, null);
    }

    private void failAssign(SegmentHolder segmentHolder, Exception e) {
        if (e != null) {
            log.error(e, "Server[%s], throwable caught when submitting [%s].", this.basePath, segmentHolder);
        }
        this.failedAssignCount.getAndIncrement();
        this.actionCompleted(segmentHolder);
    }

    private void executeCallbacks(SegmentHolder holder) {
        for (LoadPeonCallback callback : holder.snapshotCallbacks()) {
            this.callBackExecutor.submit(() -> callback.execute());
        }
    }

    private static class SegmentHolder {
        private final DataSegment segment;
        private final DataSegmentChangeRequest changeRequest;
        private final int type;
        private final List<LoadPeonCallback> callbacks = new ArrayList<LoadPeonCallback>();

        private SegmentHolder(DataSegment segment, int type, Collection<LoadPeonCallback> callbacksParam) {
            this.segment = segment;
            this.type = type;
            this.changeRequest = type == 1 ? new SegmentChangeRequestLoad(segment) : new SegmentChangeRequestDrop(segment);
            for (LoadPeonCallback c : callbacksParam) {
                if (c == null) continue;
                this.callbacks.add(c);
            }
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public int getType() {
            return this.type;
        }

        public String getSegmentIdentifier() {
            return this.segment.getId().toString();
        }

        public long getSegmentSize() {
            return this.segment.getSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(@Nullable LoadPeonCallback newCallback) {
            if (newCallback != null) {
                List<LoadPeonCallback> list = this.callbacks;
                synchronized (list) {
                    this.callbacks.add(newCallback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<LoadPeonCallback> snapshotCallbacks() {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                return ImmutableList.copyOf(this.callbacks);
            }
        }

        public DataSegmentChangeRequest getChangeRequest() {
            return this.changeRequest;
        }

        public String toString() {
            return this.changeRequest.toString();
        }
    }

    private class SegmentChangeProcessor
    implements Runnable {
        private final SegmentHolder segmentHolder;

        private SegmentChangeProcessor(SegmentHolder segmentHolder) {
            this.segmentHolder = segmentHolder;
        }

        @Override
        public void run() {
            try {
                String path = ZKPaths.makePath((String)CuratorLoadQueuePeon.this.basePath, (String)this.segmentHolder.getSegmentIdentifier());
                byte[] payload = CuratorLoadQueuePeon.this.jsonMapper.writeValueAsBytes(this.segmentHolder.getChangeRequest());
                ((ACLBackgroundPathAndBytesable)CuratorLoadQueuePeon.this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, payload);
                log.debug("ZKNode created for server to [%s] %s [%s]", CuratorLoadQueuePeon.this.basePath, this.segmentHolder.getType() == 1 ? "load" : "drop", this.segmentHolder.getSegmentIdentifier());
                ScheduledFuture<?> nodeDeletedCheck = this.scheduleNodeDeletedCheck(path);
                Stat stat = (Stat)((BackgroundPathable)CuratorLoadQueuePeon.this.curator.checkExists().usingWatcher(watchedEvent -> {
                    switch (watchedEvent.getType()) {
                        case NodeDeleted: {
                            nodeDeletedCheck.cancel(true);
                            CuratorLoadQueuePeon.this.entryRemoved(this.segmentHolder, watchedEvent.getPath());
                            break;
                        }
                    }
                })).forPath(path);
                if (stat == null) {
                    byte[] noopPayload = CuratorLoadQueuePeon.this.jsonMapper.writeValueAsBytes(new SegmentChangeRequestNoop());
                    ((ACLBackgroundPathAndBytesable)CuratorLoadQueuePeon.this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, noopPayload);
                    CuratorLoadQueuePeon.this.entryRemoved(this.segmentHolder, path);
                }
            }
            catch (KeeperException.NodeExistsException ne) {
                log.warn(ne, "ZK node already exists because segment change request hasn't yet been processed", new Object[0]);
                CuratorLoadQueuePeon.this.failAssign(this.segmentHolder);
            }
            catch (Exception e) {
                CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, e);
            }
        }

        @Nonnull
        private ScheduledFuture<?> scheduleNodeDeletedCheck(String path) {
            return CuratorLoadQueuePeon.this.processingExecutor.schedule(() -> {
                try {
                    if (CuratorLoadQueuePeon.this.curator.checkExists().forPath(path) != null) {
                        CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, new ISE("%s was never removed! Failing this operation!", path));
                    } else {
                        log.debug("%s detected to be removed. ", path);
                    }
                }
                catch (Exception e) {
                    log.error(e, "Exception caught and ignored when checking whether zk node was deleted", new Object[0]);
                    CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, e);
                }
            }, CuratorLoadQueuePeon.this.config.getLoadTimeoutDelay().getMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

