/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import javax.annotation.Nullable;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class JettyUtils {
    private static final Logger log = new Logger(JettyUtils.class);

    public static String concatenateForRewrite(String base, String encodedPath, @Nullable String encodedQueryString) {
        StringBuilder url = new StringBuilder(base).append(encodedPath);
        if (encodedQueryString != null) {
            url.append("?").append(encodedQueryString);
        }
        return url.toString();
    }

    @Nullable
    public static String getQueryParam(UriInfo uriInfo, String name, String compatiblityName) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String paramValue = (String)queryParameters.getFirst((Object)name);
        if (paramValue != null) {
            return paramValue;
        }
        String compatibilityParamValue = (String)queryParameters.getFirst((Object)compatiblityName);
        if (compatibilityParamValue != null) {
            log.warn("Parameter %s in %s query has been renamed to %s. Use the new parameter name.", compatiblityName, uriInfo.getPath(), name);
            return compatibilityParamValue;
        }
        return null;
    }
}

