/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.vector;

import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public abstract class BaseLongVectorValueSelector
implements VectorValueSelector {
    protected final ReadableVectorOffset offset;
    private int floatId = -1;
    private int doubleId = -1;
    private float[] floatVector;
    private double[] doubleVector;

    public BaseLongVectorValueSelector(ReadableVectorOffset offset) {
        this.offset = offset;
    }

    @Override
    public int getCurrentVectorSize() {
        return this.offset.getCurrentVectorSize();
    }

    @Override
    public int getMaxVectorSize() {
        return this.offset.getMaxVectorSize();
    }

    @Override
    public float[] getFloatVector() {
        if (this.floatId == this.offset.getId()) {
            return this.floatVector;
        }
        if (this.floatVector == null) {
            this.floatVector = new float[this.offset.getMaxVectorSize()];
        }
        long[] longVector = this.getLongVector();
        for (int i = 0; i < this.getCurrentVectorSize(); ++i) {
            this.floatVector[i] = longVector[i];
        }
        this.floatId = this.offset.getId();
        return this.floatVector;
    }

    @Override
    public double[] getDoubleVector() {
        if (this.doubleId == this.offset.getId()) {
            return this.doubleVector;
        }
        if (this.doubleVector == null) {
            this.doubleVector = new double[this.offset.getMaxVectorSize()];
        }
        long[] longVector = this.getLongVector();
        for (int i = 0; i < this.getCurrentVectorSize(); ++i) {
            this.doubleVector[i] = longVector[i];
        }
        this.doubleId = this.offset.getId();
        return this.doubleVector;
    }
}

