/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.vector;

import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public abstract class BaseDoubleVectorValueSelector
implements VectorValueSelector {
    protected final ReadableVectorOffset offset;
    private int longId = -1;
    private int floatId = -1;
    private long[] longVector;
    private float[] floatVector;

    public BaseDoubleVectorValueSelector(ReadableVectorOffset offset) {
        this.offset = offset;
    }

    @Override
    public int getCurrentVectorSize() {
        return this.offset.getCurrentVectorSize();
    }

    @Override
    public int getMaxVectorSize() {
        return this.offset.getMaxVectorSize();
    }

    @Override
    public long[] getLongVector() {
        if (this.longId == this.offset.getId()) {
            return this.longVector;
        }
        if (this.longVector == null) {
            this.longVector = new long[this.offset.getMaxVectorSize()];
        }
        double[] doubleVector = this.getDoubleVector();
        for (int i = 0; i < this.getCurrentVectorSize(); ++i) {
            this.longVector[i] = (long)doubleVector[i];
        }
        this.longId = this.offset.getId();
        return this.longVector;
    }

    @Override
    public float[] getFloatVector() {
        if (this.floatId == this.offset.getId()) {
            return this.floatVector;
        }
        if (this.floatVector == null) {
            this.floatVector = new float[this.offset.getMaxVectorSize()];
        }
        double[] doubleVector = this.getDoubleVector();
        for (int i = 0; i < this.getCurrentVectorSize(); ++i) {
            this.floatVector[i] = (float)doubleVector[i];
        }
        this.floatId = this.offset.getId();
        return this.floatVector;
    }
}

