/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.impl.AbstractTextFilesFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.utils.CompressionUtils;

public class LocalFirehoseFactory
extends AbstractTextFilesFirehoseFactory<File> {
    private static final EmittingLogger log = new EmittingLogger(LocalFirehoseFactory.class);
    private final File baseDir;
    private final String filter;
    @Nullable
    private final StringInputRowParser parser;

    @JsonCreator
    public LocalFirehoseFactory(@JsonProperty(value="baseDir") File baseDir, @JsonProperty(value="filter") String filter, @Nullable @JsonProperty(value="parser") StringInputRowParser parser) {
        this.baseDir = baseDir;
        this.filter = filter;
        this.parser = parser;
    }

    @JsonProperty
    public File getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty
    @Nullable
    public StringInputRowParser getParser() {
        return this.parser;
    }

    @Override
    protected Collection<File> initObjects() {
        return FileUtils.listFiles((File)Preconditions.checkNotNull(this.baseDir).getAbsoluteFile(), (IOFileFilter)new WildcardFileFilter(this.filter), (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    @Override
    protected InputStream openObjectStream(File object) throws IOException {
        return FileUtils.openInputStream((File)object);
    }

    @Override
    protected InputStream wrapObjectStream(File object, InputStream stream) throws IOException {
        return CompressionUtils.decompress(stream, object.getPath());
    }

    @Override
    public FiniteFirehoseFactory<StringInputRowParser, File> withSplit(InputSplit<File> split) {
        File newFile = split.get();
        File baseDir = newFile.getParentFile();
        String filter = newFile.getName();
        return new LocalFirehoseFactory(baseDir, filter, this.parser);
    }
}

