/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.segment.realtime.firehose.InlineFirehose;

public class InlineFirehoseFactory
implements FiniteFirehoseFactory<StringInputRowParser, String> {
    private final String data;

    @JsonCreator
    @VisibleForTesting
    public InlineFirehoseFactory(@JsonProperty(value="data") String data) {
        this.data = Preconditions.checkNotNull(data, "data");
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @Override
    public Firehose connect(StringInputRowParser parser, @Nullable File temporaryDirectory) throws IOException {
        return new InlineFirehose(this.data, parser);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineFirehoseFactory factory = (InlineFirehoseFactory)o;
        return this.data.equals(factory.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public Stream<InputSplit<String>> getSplits(@Nullable SplitHintSpec splitHintSpec) {
        return Stream.of(new InputSplit<String>(this.data));
    }

    @Override
    public int getNumSplits(@Nullable SplitHintSpec splitHintSpec) {
        return 1;
    }

    @Override
    public FiniteFirehoseFactory<StringInputRowParser, String> withSplit(InputSplit<String> split) {
        return new InlineFirehoseFactory(split.get());
    }
}

