/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;

public class FixedCountFirehoseFactory
implements FirehoseFactory {
    private final FirehoseFactory delegate;
    private final int count;

    @JsonCreator
    public FixedCountFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegate, @JsonProperty(value="count") int count) {
        this.delegate = delegate;
        this.count = count;
    }

    @JsonProperty
    public FirehoseFactory getDelegate() {
        return this.delegate;
    }

    @JsonProperty
    public int getCount() {
        return this.count;
    }

    public Firehose connect(final InputRowParser parser, final File temporaryDirectory) throws IOException {
        return new Firehose(){
            private int i = 0;
            private final Firehose delegateFirehose = FixedCountFirehoseFactory.access$000(FixedCountFirehoseFactory.this).connect(parser, temporaryDirectory);

            @Override
            public boolean hasMore() throws IOException {
                return this.i < FixedCountFirehoseFactory.this.count && this.delegateFirehose.hasMore();
            }

            @Override
            @Nullable
            public InputRow nextRow() throws IOException {
                Preconditions.checkArgument(this.i++ < FixedCountFirehoseFactory.this.count, "Max events limit reached.");
                return this.delegateFirehose.nextRow();
            }

            @Override
            public void close() throws IOException {
                this.delegateFirehose.close();
            }
        };
    }

    static /* synthetic */ FirehoseFactory access$000(FixedCountFirehoseFactory x0) {
        return x0.delegate;
    }
}

