/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Stopwatch;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.data.input.Committer;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.IndexMerger;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.TuningConfigs;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireHydrant;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.Committed;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SinkQuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.Sink;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.org.apache.druid.timeline.CompactionState;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.Interval;
import org.joda.time.ReadablePeriod;

public class AppenderatorImpl
implements Appenderator {
    private static final EmittingLogger log = new EmittingLogger(AppenderatorImpl.class);
    private static final int WARN_DELAY = 1000;
    private static final String IDENTIFIER_FILE_NAME = "identifier.json";
    private final String myId;
    private final DataSchema schema;
    private final AppenderatorConfig tuningConfig;
    private final boolean storeCompactionState;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final Cache cache;
    private final ConcurrentMap<SegmentIdWithShardSpec, Sink> sinks = new ConcurrentHashMap<SegmentIdWithShardSpec, Sink>();
    private final Set<SegmentIdWithShardSpec> droppingSinks = Sets.newConcurrentHashSet();
    private final VersionedIntervalTimeline<String, Sink> sinkTimeline;
    private final long maxBytesTuningConfig;
    private final QuerySegmentWalker texasRanger;
    private final AtomicInteger rowsCurrentlyInMemory = new AtomicInteger();
    private final AtomicInteger totalRows = new AtomicInteger();
    private final AtomicLong bytesCurrentlyInMemory = new AtomicLong();
    private final Lock commitLock = new ReentrantLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile ListeningExecutorService persistExecutor = null;
    private volatile ListeningExecutorService pushExecutor = null;
    private volatile ListeningExecutorService intermediateTempExecutor = null;
    private volatile long nextFlush;
    private volatile FileLock basePersistDirLock = null;
    private volatile FileChannel basePersistDirLockChannel = null;
    private volatile Throwable persistError;

    AppenderatorImpl(String id, DataSchema schema, AppenderatorConfig tuningConfig, boolean storeCompactionState, FireDepartmentMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, DataSegmentAnnouncer segmentAnnouncer, @Nullable SinkQuerySegmentWalker sinkQuerySegmentWalker, IndexIO indexIO, IndexMerger indexMerger, Cache cache) {
        this.myId = id;
        this.schema = Preconditions.checkNotNull(schema, "schema");
        this.tuningConfig = Preconditions.checkNotNull(tuningConfig, "tuningConfig");
        this.storeCompactionState = storeCompactionState;
        this.metrics = Preconditions.checkNotNull(metrics, "metrics");
        this.dataSegmentPusher = Preconditions.checkNotNull(dataSegmentPusher, "dataSegmentPusher");
        this.objectMapper = Preconditions.checkNotNull(objectMapper, "objectMapper");
        this.segmentAnnouncer = Preconditions.checkNotNull(segmentAnnouncer, "segmentAnnouncer");
        this.indexIO = Preconditions.checkNotNull(indexIO, "indexIO");
        this.indexMerger = Preconditions.checkNotNull(indexMerger, "indexMerger");
        this.cache = cache;
        this.texasRanger = sinkQuerySegmentWalker;
        this.sinkTimeline = sinkQuerySegmentWalker == null ? new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER) : sinkQuerySegmentWalker.getSinkTimeline();
        this.maxBytesTuningConfig = TuningConfigs.getMaxBytesInMemoryOrDefault(tuningConfig.getMaxBytesInMemory());
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    public String getDataSource() {
        return this.schema.getDataSource();
    }

    @Override
    public Object startJob() {
        this.tuningConfig.getBasePersistDirectory().mkdirs();
        this.lockBasePersistDirectory();
        Object retVal = this.bootstrapSinksFromDisk();
        this.initializeExecutors();
        this.resetNextFlush();
        return retVal;
    }

    private void throwPersistErrorIfExists() {
        if (this.persistError != null) {
            throw new RE(this.persistError, "Error while persisting", new Object[0]);
        }
    }

    @Override
    public Appenderator.AppenderatorAddResult add(SegmentIdWithShardSpec identifier, InputRow row, @Nullable Supplier<Committer> committerSupplier, boolean allowIncrementalPersists) throws IndexSizeExceededException, SegmentNotWritableException {
        long bytesInMemoryAfterAdd;
        int sinkRowsInMemoryAfterAdd;
        IncrementalIndexAddResult addResult;
        this.throwPersistErrorIfExists();
        if (!identifier.getDataSource().equals(this.schema.getDataSource())) {
            throw new IAE("Expected dataSource[%s] but was asked to insert row for dataSource[%s]?!", this.schema.getDataSource(), identifier.getDataSource());
        }
        Sink sink = this.getOrCreateSink(identifier);
        this.metrics.reportMessageMaxTimestamp(row.getTimestampFromEpoch());
        int sinkRowsInMemoryBeforeAdd = sink.getNumRowsInMemory();
        long bytesInMemoryBeforeAdd = sink.getBytesInMemory();
        try {
            addResult = sink.add(row, !allowIncrementalPersists);
            sinkRowsInMemoryAfterAdd = addResult.getRowCount();
            bytesInMemoryAfterAdd = addResult.getBytesInMemory();
        }
        catch (IndexSizeExceededException e) {
            log.error(e, "Sink for segment[%s] was unexpectedly full!", identifier);
            throw e;
        }
        if (sinkRowsInMemoryAfterAdd < 0) {
            throw new SegmentNotWritableException("Attempt to add row to swapped-out sink for segment[%s].", identifier);
        }
        int numAddedRows = sinkRowsInMemoryAfterAdd - sinkRowsInMemoryBeforeAdd;
        this.rowsCurrentlyInMemory.addAndGet(numAddedRows);
        this.bytesCurrentlyInMemory.addAndGet(bytesInMemoryAfterAdd - bytesInMemoryBeforeAdd);
        this.totalRows.addAndGet(numAddedRows);
        boolean isPersistRequired = false;
        boolean persist = false;
        ArrayList<String> persistReasons = new ArrayList<String>();
        if (!sink.canAppendRow()) {
            persist = true;
            persistReasons.add("No more rows can be appended to sink");
        }
        if (System.currentTimeMillis() > this.nextFlush) {
            persist = true;
            persistReasons.add(StringUtils.format("current time[%d] is greater than nextFlush[%d]", System.currentTimeMillis(), this.nextFlush));
        }
        if (this.rowsCurrentlyInMemory.get() >= this.tuningConfig.getMaxRowsInMemory()) {
            persist = true;
            persistReasons.add(StringUtils.format("rowsCurrentlyInMemory[%d] is greater than maxRowsInMemory[%d]", this.rowsCurrentlyInMemory.get(), this.tuningConfig.getMaxRowsInMemory()));
        }
        if (this.bytesCurrentlyInMemory.get() >= this.maxBytesTuningConfig) {
            persist = true;
            persistReasons.add(StringUtils.format("bytesCurrentlyInMemory[%d] is greater than maxBytesInMemory[%d]", this.bytesCurrentlyInMemory.get(), this.maxBytesTuningConfig));
        }
        if (persist) {
            if (allowIncrementalPersists) {
                log.info("Flushing in-memory data to disk because %s.", String.join((CharSequence)",", persistReasons));
                Futures.addCallback(this.persistAll(committerSupplier == null ? null : committerSupplier.get()), new FutureCallback<Object>(){

                    @Override
                    public void onSuccess(@Nullable Object result) {
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        AppenderatorImpl.this.persistError = t;
                    }
                });
            } else {
                isPersistRequired = true;
            }
        }
        return new Appenderator.AppenderatorAddResult(identifier, sink.getNumRows(), isPersistRequired, addResult.getParseException());
    }

    @Override
    public List<SegmentIdWithShardSpec> getSegments() {
        return ImmutableList.copyOf(this.sinks.keySet());
    }

    @Override
    public int getRowCount(SegmentIdWithShardSpec identifier) {
        Sink sink = (Sink)this.sinks.get(identifier);
        if (sink == null) {
            throw new ISE("No such sink: %s", identifier);
        }
        return sink.getNumRows();
    }

    @Override
    public int getTotalRowCount() {
        return this.totalRows.get();
    }

    @VisibleForTesting
    int getRowsInMemory() {
        return this.rowsCurrentlyInMemory.get();
    }

    @VisibleForTesting
    long getBytesCurrentlyInMemory() {
        return this.bytesCurrentlyInMemory.get();
    }

    @VisibleForTesting
    long getBytesInMemory(SegmentIdWithShardSpec identifier) {
        Sink sink = (Sink)this.sinks.get(identifier);
        if (sink == null) {
            throw new ISE("No such sink: %s", identifier);
        }
        return sink.getBytesInMemory();
    }

    private Sink getOrCreateSink(SegmentIdWithShardSpec identifier) {
        Sink retVal = (Sink)this.sinks.get(identifier);
        if (retVal == null) {
            Map<String, Object> indexSpecMap = this.objectMapper.convertValue((Object)this.tuningConfig.getIndexSpec(), new TypeReference<Map<String, Object>>(){});
            retVal = new Sink(identifier.getInterval(), this.schema, identifier.getShardSpec(), this.storeCompactionState ? new CompactionState(this.tuningConfig.getPartitionsSpec(), indexSpecMap) : null, identifier.getVersion(), this.tuningConfig.getMaxRowsInMemory(), this.maxBytesTuningConfig, this.tuningConfig.isReportParseExceptions(), null);
            try {
                this.segmentAnnouncer.announceSegment(retVal.getSegment());
            }
            catch (IOException e) {
                log.makeAlert(e, "Failed to announce new segment[%s]", this.schema.getDataSource()).addData("interval", retVal.getInterval()).emit();
            }
            this.sinks.put(identifier, retVal);
            this.metrics.setSinkCount(this.sinks.size());
            this.sinkTimeline.add(retVal.getInterval(), retVal.getVersion(), identifier.getShardSpec().createChunk(retVal));
        }
        return retVal;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        if (this.texasRanger == null) {
            throw new IllegalStateException("Don't query me, bro.");
        }
        return this.texasRanger.getQueryRunnerForIntervals(query, intervals);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        if (this.texasRanger == null) {
            throw new IllegalStateException("Don't query me, bro.");
        }
        return this.texasRanger.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public void clear() throws InterruptedException {
        try {
            this.throwPersistErrorIfExists();
            if (this.persistExecutor != null) {
                ListenableFuture<Object> uncommitFuture = this.persistExecutor.submit(() -> {
                    try {
                        this.commitLock.lock();
                        this.objectMapper.writeValue(this.computeCommitFile(), (Object)Committed.nil());
                    }
                    finally {
                        this.commitLock.unlock();
                    }
                    return null;
                });
                uncommitFuture.get();
                ArrayList futures = new ArrayList();
                for (Map.Entry entry : this.sinks.entrySet()) {
                    futures.add(this.abandonSegment((SegmentIdWithShardSpec)entry.getKey(), (Sink)entry.getValue(), true));
                }
                Futures.allAsList(futures).get();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListenableFuture<?> drop(SegmentIdWithShardSpec identifier) {
        Sink sink = (Sink)this.sinks.get(identifier);
        if (sink != null) {
            return this.abandonSegment(identifier, sink, true);
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Object> persistAll(final @Nullable Committer committer) {
        this.throwPersistErrorIfExists();
        final HashMap<String, Integer> currentHydrants = new HashMap<String, Integer>();
        final ArrayList<Pair<FireHydrant, SegmentIdWithShardSpec>> indexesToPersist = new ArrayList<Pair<FireHydrant, SegmentIdWithShardSpec>>();
        int numPersistedRows = 0;
        long bytesPersisted = 0L;
        for (Map.Entry entry : this.sinks.entrySet()) {
            SegmentIdWithShardSpec identifier = (SegmentIdWithShardSpec)entry.getKey();
            Sink sink = (Sink)entry.getValue();
            if (sink == null) {
                throw new ISE("No sink for identifier: %s", identifier);
            }
            ArrayList<FireHydrant> hydrants = Lists.newArrayList(sink);
            currentHydrants.put(identifier.toString(), hydrants.size());
            numPersistedRows += sink.getNumRowsInMemory();
            bytesPersisted += sink.getBytesInMemory();
            int limit = sink.isWritable() ? hydrants.size() - 1 : hydrants.size();
            for (FireHydrant hydrant : hydrants.subList(0, limit)) {
                if (hydrant.hasSwapped()) continue;
                log.debug("Hydrant[%s] hasn't persisted yet, persisting. Segment[%s]", hydrant, identifier);
                indexesToPersist.add(Pair.of(hydrant, identifier));
            }
            if (!sink.swappable()) continue;
            indexesToPersist.add(Pair.of(sink.swap(), identifier));
        }
        log.debug("Submitting persist runnable for dataSource[%s]", this.schema.getDataSource());
        final Object commitMetadata = committer == null ? null : committer.getMetadata();
        Stopwatch runExecStopwatch = Stopwatch.createStarted();
        final Stopwatch persistStopwatch = Stopwatch.createStarted();
        ListenableFuture<Object> future = this.persistExecutor.submit(new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                try {
                    HashMap<String, Integer> commitHydrants;
                    for (Pair pair : indexesToPersist) {
                        AppenderatorImpl.this.metrics.incrementRowOutputCount(AppenderatorImpl.this.persistHydrant((FireHydrant)pair.lhs, (SegmentIdWithShardSpec)pair.rhs));
                    }
                    if (committer != null) {
                        log.debug("Committing metadata[%s] for sinks[%s].", commitMetadata, Joiner.on(", ").join(currentHydrants.entrySet().stream().map(entry -> StringUtils.format("%s:%d", entry.getKey(), entry.getValue())).collect(Collectors.toList())));
                        committer.run();
                        try {
                            AppenderatorImpl.this.commitLock.lock();
                            commitHydrants = new HashMap<String, Integer>();
                            Committed oldCommit = AppenderatorImpl.this.readCommit();
                            if (oldCommit != null) {
                                commitHydrants.putAll(oldCommit.getHydrants());
                            }
                            commitHydrants.putAll(currentHydrants);
                            AppenderatorImpl.this.writeCommit(new Committed(commitHydrants, commitMetadata));
                        }
                        finally {
                            AppenderatorImpl.this.commitLock.unlock();
                        }
                    }
                    log.info("Flushed in-memory data with commit metadata [%s] for segments: %s", commitMetadata, indexesToPersist.stream().map(itp -> ((SegmentIdWithShardSpec)itp.rhs).asSegmentId().toString()).distinct().collect(Collectors.joining(", ")));
                    commitHydrants = commitMetadata;
                    return commitHydrants;
                }
                catch (IOException e) {
                    AppenderatorImpl.this.metrics.incrementFailedPersists();
                    throw e;
                }
                finally {
                    AppenderatorImpl.this.metrics.incrementNumPersists();
                    AppenderatorImpl.this.metrics.incrementPersistTimeMillis(persistStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    persistStopwatch.stop();
                }
            }
        });
        long startDelay = runExecStopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.metrics.incrementPersistBackPressureMillis(startDelay);
        if (startDelay > 1000L) {
            log.warn("Ingestion was throttled for [%,d] millis because persists were pending.", startDelay);
        }
        runExecStopwatch.stop();
        this.resetNextFlush();
        this.rowsCurrentlyInMemory.addAndGet(-numPersistedRows);
        this.bytesCurrentlyInMemory.addAndGet(-bytesPersisted);
        return future;
    }

    @Override
    public ListenableFuture<SegmentsAndMetadata> push(Collection<SegmentIdWithShardSpec> identifiers, @Nullable Committer committer, boolean useUniquePath) {
        HashMap<SegmentIdWithShardSpec, Sink> theSinks = new HashMap<SegmentIdWithShardSpec, Sink>();
        for (SegmentIdWithShardSpec identifier : identifiers) {
            Sink sink = (Sink)this.sinks.get(identifier);
            if (sink == null) {
                throw new ISE("No sink for identifier: %s", identifier);
            }
            theSinks.put(identifier, sink);
            if (!sink.finishWriting()) continue;
            this.totalRows.addAndGet(-sink.getNumRows());
        }
        return Futures.transform(this.persistAll(committer), commitMetadata -> {
            ArrayList<DataSegment> dataSegments = new ArrayList<DataSegment>();
            log.debug("Building and pushing segments: %s", theSinks.keySet().stream().map(SegmentIdWithShardSpec::toString).collect(Collectors.joining(", ")));
            for (Map.Entry entry : theSinks.entrySet()) {
                if (this.droppingSinks.contains(entry.getKey())) {
                    log.warn("Skipping push of currently-dropping sink[%s]", entry.getKey());
                    continue;
                }
                DataSegment dataSegment = this.mergeAndPush((SegmentIdWithShardSpec)entry.getKey(), (Sink)entry.getValue(), useUniquePath);
                if (dataSegment != null) {
                    dataSegments.add(dataSegment);
                    continue;
                }
                log.warn("mergeAndPush[%s] returned null, skipping.", entry.getKey());
            }
            return new SegmentsAndMetadata(dataSegments, commitMetadata);
        }, (Executor)this.pushExecutor);
    }

    private ListenableFuture<?> pushBarrier() {
        return this.intermediateTempExecutor.submit(() -> this.pushExecutor.submit(() -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DataSegment mergeAndPush(SegmentIdWithShardSpec identifier, Sink sink, boolean useUniquePath) {
        if (this.sinks.get(identifier) != sink) {
            log.warn("Sink for segment[%s] no longer valid, bailing out of mergeAndPush.", identifier);
            return null;
        }
        File persistDir = this.computePersistDir(identifier);
        File mergedTarget = new File(persistDir, "merged");
        File descriptorFile = this.computeDescriptorFile(identifier);
        for (FireHydrant hydrant : sink) {
            if (sink.isWritable()) {
                throw new ISE("WTF?! Expected sink to be no longer writable before mergeAndPush. Segment[%s].", identifier);
            }
            FireHydrant fireHydrant = hydrant;
            synchronized (fireHydrant) {
                if (!hydrant.hasSwapped()) {
                    throw new ISE("WTF?! Expected sink to be fully persisted before mergeAndPush. Segment[%s].", identifier);
                }
            }
        }
        try {
            long mergeFinishTime;
            File mergedFile;
            if (descriptorFile.exists()) {
                if (useUniquePath) {
                    log.debug("Segment[%s] already pushed, but we want a unique path, so will push again with a new path.", identifier);
                } else {
                    log.info("Segment[%s] already pushed, skipping.", identifier);
                    return this.objectMapper.readValue(descriptorFile, DataSegment.class);
                }
            }
            this.removeDirectory(mergedTarget);
            if (mergedTarget.exists()) {
                throw new ISE("Merged target[%s] exists after removing?!", mergedTarget);
            }
            long startTime = System.nanoTime();
            ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
            try (Closer closer = Closer.create();){
                for (FireHydrant fireHydrant : sink) {
                    Pair<Segment, Closeable> segmentAndCloseable = fireHydrant.getAndIncrementSegment();
                    QueryableIndex queryableIndex = ((Segment)segmentAndCloseable.lhs).asQueryableIndex();
                    log.debug("Segment[%s] adding hydrant[%s]", identifier, fireHydrant);
                    indexes.add(queryableIndex);
                    closer.register((Closeable)segmentAndCloseable.rhs);
                }
                mergedFile = this.indexMerger.mergeQueryableIndex(indexes, this.schema.getGranularitySpec().isRollup(), this.schema.getAggregators(), mergedTarget, this.tuningConfig.getIndexSpec(), this.tuningConfig.getSegmentWriteOutMediumFactory());
                mergeFinishTime = System.nanoTime();
                log.debug("Segment[%s] built in %,dms.", identifier, (mergeFinishTime - startTime) / 1000000L);
            }
            DataSegment segment = RetryUtils.retry(() -> this.dataSegmentPusher.push(mergedFile, sink.getSegment().withDimensions(IndexMerger.getMergedDimensionsFromQueryableIndexes(indexes)), useUniquePath), exception -> exception instanceof Exception, 5);
            long pushFinishTime = System.nanoTime();
            this.objectMapper.writeValue(descriptorFile, (Object)segment);
            log.info("Segment[%s] of %,d bytes built from %d incremental persist(s) in %,dms; pushed to deep storage in %,dms. Load spec is: %s", identifier, segment.getSize(), indexes.size(), (mergeFinishTime - startTime) / 1000000L, (pushFinishTime - mergeFinishTime) / 1000000L, this.objectMapper.writeValueAsString(segment.getLoadSpec()));
            return segment;
        }
        catch (Exception e) {
            this.metrics.incrementFailedHandoffs();
            log.warn(e, "Failed to push merged index for segment[%s].", identifier);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            log.debug("Appenderator already closed, skipping close() call.", new Object[0]);
            return;
        }
        log.debug("Shutting down...", new Object[0]);
        ArrayList futures = new ArrayList();
        for (Map.Entry entry : this.sinks.entrySet()) {
            futures.add(this.abandonSegment((SegmentIdWithShardSpec)entry.getKey(), (Sink)entry.getValue(), false));
        }
        try {
            Futures.allAsList(futures).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn(e, "Interrupted during close()", new Object[0]);
        }
        catch (ExecutionException e) {
            log.warn(e, "Unable to abandon existing segments during close()", new Object[0]);
        }
        try {
            this.shutdownExecutors();
            Preconditions.checkState(this.persistExecutor == null || this.persistExecutor.awaitTermination(365L, TimeUnit.DAYS), "persistExecutor not terminated");
            Preconditions.checkState(this.pushExecutor == null || this.pushExecutor.awaitTermination(365L, TimeUnit.DAYS), "pushExecutor not terminated");
            Preconditions.checkState(this.intermediateTempExecutor == null || this.intermediateTempExecutor.awaitTermination(365L, TimeUnit.DAYS), "intermediateTempExecutor not terminated");
            this.persistExecutor = null;
            this.pushExecutor = null;
            this.intermediateTempExecutor = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE("Failed to shutdown executors during close()", new Object[0]);
        }
        this.unlockBasePersistDirectory();
    }

    @Override
    public void closeNow() {
        if (!this.closed.compareAndSet(false, true)) {
            log.debug("Appenderator already closed, skipping closeNow() call.", new Object[0]);
            return;
        }
        log.debug("Shutting down immediately...", new Object[0]);
        for (Map.Entry entry : this.sinks.entrySet()) {
            try {
                this.segmentAnnouncer.unannounceSegment(((Sink)entry.getValue()).getSegment());
            }
            catch (Exception e) {
                log.makeAlert(e, "Failed to unannounce segment[%s]", this.schema.getDataSource()).addData("identifier", ((SegmentIdWithShardSpec)entry.getKey()).toString()).emit();
            }
        }
        try {
            this.shutdownExecutors();
            Preconditions.checkState(this.persistExecutor == null || this.persistExecutor.awaitTermination(365L, TimeUnit.DAYS), "persistExecutor not terminated");
            Preconditions.checkState(this.intermediateTempExecutor == null || this.intermediateTempExecutor.awaitTermination(365L, TimeUnit.DAYS), "intermediateTempExecutor not terminated");
            this.persistExecutor = null;
            this.intermediateTempExecutor = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE("Failed to shutdown executors during close()", new Object[0]);
        }
    }

    private void lockBasePersistDirectory() {
        if (this.basePersistDirLock == null) {
            try {
                this.basePersistDirLockChannel = FileChannel.open(this.computeLockFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.basePersistDirLock = this.basePersistDirLockChannel.tryLock();
                if (this.basePersistDirLock == null) {
                    throw new ISE("Cannot acquire lock on basePersistDir: %s", this.computeLockFile());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void unlockBasePersistDirectory() {
        try {
            if (this.basePersistDirLock != null) {
                this.basePersistDirLock.release();
                this.basePersistDirLockChannel.close();
                this.basePersistDirLock = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeExecutors() {
        int maxPendingPersists = this.tuningConfig.getMaxPendingPersists();
        if (this.persistExecutor == null) {
            this.persistExecutor = MoreExecutors.listeningDecorator(Execs.newBlockingSingleThreaded("[" + this.myId + "]-appenderator-persist", maxPendingPersists));
        }
        if (this.pushExecutor == null) {
            this.pushExecutor = MoreExecutors.listeningDecorator(Execs.newBlockingSingleThreaded("[" + this.myId + "]-appenderator-merge", 1));
        }
        if (this.intermediateTempExecutor == null) {
            this.intermediateTempExecutor = MoreExecutors.listeningDecorator(Execs.newBlockingSingleThreaded("[" + this.myId + "]-appenderator-abandon", 0));
        }
    }

    private void shutdownExecutors() {
        if (this.persistExecutor != null) {
            this.persistExecutor.shutdownNow();
        }
        if (this.pushExecutor != null) {
            this.pushExecutor.shutdownNow();
        }
        if (this.intermediateTempExecutor != null) {
            this.intermediateTempExecutor.shutdownNow();
        }
    }

    private void resetNextFlush() {
        this.nextFlush = DateTimes.nowUtc().plus((ReadablePeriod)this.tuningConfig.getIntermediatePersistPeriod()).getMillis();
    }

    private Object bootstrapSinksFromDisk() {
        Committed committed;
        Preconditions.checkState(this.sinks.isEmpty(), "Already bootstrapped?!");
        File baseDir = this.tuningConfig.getBasePersistDirectory();
        if (!baseDir.exists()) {
            return null;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return null;
        }
        File commitFile = null;
        try {
            this.commitLock.lock();
            commitFile = this.computeCommitFile();
            committed = commitFile.exists() ? this.objectMapper.readValue(commitFile, Committed.class) : Committed.nil();
        }
        catch (Exception e) {
            throw new ISE(e, "Failed to read commitFile: %s", commitFile);
        }
        finally {
            this.commitLock.unlock();
        }
        int rowsSoFar = 0;
        if (committed.equals(Committed.nil())) {
            log.debug("No previously committed metadata.", new Object[0]);
        } else {
            log.info("Loading partially-persisted segments[%s] from[%s] with commit metadata: %s", String.join((CharSequence)", ", committed.getHydrants().keySet()), baseDir, committed.getMetadata());
        }
        for (File sinkDir : files) {
            File identifierFile = new File(sinkDir, IDENTIFIER_FILE_NAME);
            if (!identifierFile.isFile()) continue;
            try {
                SegmentIdWithShardSpec identifier = this.objectMapper.readValue(new File(sinkDir, IDENTIFIER_FILE_NAME), SegmentIdWithShardSpec.class);
                int committedHydrants = committed.getCommittedHydrants(identifier.toString());
                if (committedHydrants <= 0) {
                    log.info("Removing uncommitted segment at [%s].", sinkDir);
                    org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils.deleteDirectory(sinkDir);
                    continue;
                }
                File[] sinkFiles = sinkDir.listFiles((dir, fileName) -> Ints.tryParse(fileName) != null);
                Arrays.sort(sinkFiles, (o1, o2) -> Ints.compare(Integer.parseInt(o1.getName()), Integer.parseInt(o2.getName())));
                ArrayList<FireHydrant> hydrants = new ArrayList<FireHydrant>();
                for (File hydrantDir : sinkFiles) {
                    int hydrantNumber = Integer.parseInt(hydrantDir.getName());
                    if (hydrantNumber >= committedHydrants) {
                        log.info("Removing uncommitted partial segment at [%s]", hydrantDir);
                        org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils.deleteDirectory(hydrantDir);
                        continue;
                    }
                    log.debug("Loading previously persisted partial segment at [%s]", hydrantDir);
                    if (hydrantNumber != hydrants.size()) {
                        throw new ISE("Missing hydrant [%,d] in sinkDir [%s].", hydrants.size(), sinkDir);
                    }
                    hydrants.add(new FireHydrant(new QueryableIndexSegment(this.indexIO.loadIndex(hydrantDir), identifier.asSegmentId()), hydrantNumber));
                }
                if (committedHydrants != hydrants.size()) {
                    throw new ISE("Missing hydrant [%,d] in sinkDir [%s].", hydrants.size(), sinkDir);
                }
                Sink currSink = new Sink(identifier.getInterval(), this.schema, identifier.getShardSpec(), null, identifier.getVersion(), this.tuningConfig.getMaxRowsInMemory(), this.maxBytesTuningConfig, this.tuningConfig.isReportParseExceptions(), null, hydrants);
                rowsSoFar += currSink.getNumRows();
                this.sinks.put(identifier, currSink);
                this.sinkTimeline.add(currSink.getInterval(), currSink.getVersion(), identifier.getShardSpec().createChunk(currSink));
                this.segmentAnnouncer.announceSegment(currSink.getSegment());
            }
            catch (IOException e) {
                log.makeAlert(e, "Problem loading sink[%s] from disk.", this.schema.getDataSource()).addData("sinkDir", sinkDir).emit();
            }
        }
        HashSet loadedSinks = Sets.newHashSet(Iterables.transform(this.sinks.keySet(), SegmentIdWithShardSpec::toString));
        Sets.SetView missingSinks = Sets.difference(committed.getHydrants().keySet(), loadedSinks);
        if (!missingSinks.isEmpty()) {
            throw new ISE("Missing committed sinks [%s]", Joiner.on(", ").join(missingSinks));
        }
        this.totalRows.set(rowsSoFar);
        return committed.getMetadata();
    }

    private ListenableFuture<?> abandonSegment(final SegmentIdWithShardSpec identifier, final Sink sink, final boolean removeOnDiskData) {
        if (sink.finishWriting()) {
            this.rowsCurrentlyInMemory.addAndGet(-sink.getNumRowsInMemory());
            this.bytesCurrentlyInMemory.addAndGet(-sink.getBytesInMemory());
            this.totalRows.addAndGet(-sink.getNumRows());
        }
        this.droppingSinks.add(identifier);
        return Futures.transform(this.pushBarrier(), new Function<Object, Void>(){

            @Override
            @Nullable
            public Void apply(@Nullable Object input) {
                if (!AppenderatorImpl.this.sinks.remove(identifier, sink)) {
                    log.error("Sink for segment[%s] no longer valid, not abandoning.", identifier);
                    return null;
                }
                AppenderatorImpl.this.metrics.setSinkCount(AppenderatorImpl.this.sinks.size());
                if (removeOnDiskData) {
                    log.debug("Removing commit metadata for segment[%s].", identifier);
                    try {
                        AppenderatorImpl.this.commitLock.lock();
                        Committed oldCommit = AppenderatorImpl.this.readCommit();
                        if (oldCommit != null) {
                            AppenderatorImpl.this.writeCommit(oldCommit.without(identifier.toString()));
                        }
                    }
                    catch (Exception e) {
                        log.makeAlert(e, "Failed to update committed segments[%s]", AppenderatorImpl.this.schema.getDataSource()).addData("identifier", identifier.toString()).emit();
                        throw new RuntimeException(e);
                    }
                    finally {
                        AppenderatorImpl.this.commitLock.unlock();
                    }
                }
                try {
                    AppenderatorImpl.this.segmentAnnouncer.unannounceSegment(sink.getSegment());
                }
                catch (Exception e) {
                    log.makeAlert(e, "Failed to unannounce segment[%s]", AppenderatorImpl.this.schema.getDataSource()).addData("identifier", identifier.toString()).emit();
                }
                AppenderatorImpl.this.droppingSinks.remove(identifier);
                AppenderatorImpl.this.sinkTimeline.remove(sink.getInterval(), sink.getVersion(), identifier.getShardSpec().createChunk(sink));
                for (FireHydrant hydrant : sink) {
                    if (AppenderatorImpl.this.cache != null) {
                        AppenderatorImpl.this.cache.close(SinkQuerySegmentWalker.makeHydrantCacheIdentifier(hydrant));
                    }
                    hydrant.swapSegment(null);
                }
                if (removeOnDiskData) {
                    AppenderatorImpl.this.removeDirectory(AppenderatorImpl.this.computePersistDir(identifier));
                }
                log.info("Dropped segment[%s].", identifier);
                return null;
            }
        }, (Executor)this.persistExecutor);
    }

    private Committed readCommit() throws IOException {
        File commitFile = this.computeCommitFile();
        if (commitFile.exists()) {
            return this.objectMapper.readValue(commitFile, Committed.class);
        }
        return null;
    }

    private void writeCommit(Committed newCommit) throws IOException {
        File commitFile = this.computeCommitFile();
        this.objectMapper.writeValue(commitFile, (Object)newCommit);
    }

    private File computeCommitFile() {
        return new File(this.tuningConfig.getBasePersistDirectory(), "commit.json");
    }

    private File computeLockFile() {
        return new File(this.tuningConfig.getBasePersistDirectory(), ".lock");
    }

    private File computePersistDir(SegmentIdWithShardSpec identifier) {
        return new File(this.tuningConfig.getBasePersistDirectory(), identifier.toString());
    }

    private File computeIdentifierFile(SegmentIdWithShardSpec identifier) {
        return new File(this.computePersistDir(identifier), IDENTIFIER_FILE_NAME);
    }

    private File computeDescriptorFile(SegmentIdWithShardSpec identifier) {
        return new File(this.computePersistDir(identifier), "descriptor.json");
    }

    private File createPersistDirIfNeeded(SegmentIdWithShardSpec identifier) throws IOException {
        File persistDir = this.computePersistDir(identifier);
        FileUtils.forceMkdir((File)persistDir);
        this.objectMapper.writeValue(this.computeIdentifierFile(identifier), (Object)identifier);
        return persistDir;
    }

    private int persistHydrant(FireHydrant indexToPersist, SegmentIdWithShardSpec identifier) {
        FireHydrant fireHydrant = indexToPersist;
        synchronized (fireHydrant) {
            if (indexToPersist.hasSwapped()) {
                log.info("Segment[%s] hydrant[%s] already swapped. Ignoring request to persist.", identifier, indexToPersist);
                return 0;
            }
            log.debug("Segment[%s], persisting Hydrant[%s]", identifier, indexToPersist);
            try {
                long startTime = System.nanoTime();
                int numRows = indexToPersist.getIndex().size();
                File persistDir = this.createPersistDirIfNeeded(identifier);
                File persistedFile = this.indexMerger.persist(indexToPersist.getIndex(), identifier.getInterval(), new File(persistDir, String.valueOf(indexToPersist.getCount())), this.tuningConfig.getIndexSpecForIntermediatePersists(), this.tuningConfig.getSegmentWriteOutMediumFactory());
                log.info("Flushed in-memory data for segment[%s] spill[%s] to disk in [%,d] ms (%,d rows).", indexToPersist.getSegmentId(), indexToPersist.getCount(), (System.nanoTime() - startTime) / 1000000L, numRows);
                indexToPersist.swapSegment(new QueryableIndexSegment(this.indexIO.loadIndex(persistedFile), indexToPersist.getSegmentId()));
                return numRows;
            }
            catch (IOException e) {
                log.makeAlert("Incremental persist failed", new Object[0]).addData("segment", identifier.toString()).addData("dataSource", this.schema.getDataSource()).addData("count", indexToPersist.getCount()).emit();
                throw new RuntimeException(e);
            }
        }
    }

    private void removeDirectory(File target) {
        if (target.exists()) {
            try {
                org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils.deleteDirectory(target);
            }
            catch (Exception e) {
                log.makeAlert(e, "Failed to remove directory[%s]", this.schema.getDataSource()).addData("file", target).emit();
            }
        }
    }
}

