/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartmentMetrics;

public class FireDepartment
extends IngestionSpec<RealtimeIOConfig, RealtimeTuningConfig> {
    private final DataSchema dataSchema;
    private final RealtimeIOConfig ioConfig;
    private final RealtimeTuningConfig tuningConfig;
    private final FireDepartmentMetrics metrics = new FireDepartmentMetrics();

    @JsonCreator
    public FireDepartment(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") RealtimeIOConfig ioConfig, @JsonProperty(value="tuningConfig") RealtimeTuningConfig tuningConfig) {
        super(dataSchema, ioConfig, tuningConfig);
        Preconditions.checkNotNull(dataSchema, "dataSchema");
        Preconditions.checkNotNull(ioConfig, "ioConfig");
        this.dataSchema = dataSchema;
        this.ioConfig = ioConfig;
        this.tuningConfig = tuningConfig == null ? RealtimeTuningConfig.makeDefaultTuningConfig(null) : tuningConfig;
    }

    @Override
    @JsonProperty(value="dataSchema")
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @Override
    @JsonProperty(value="ioConfig")
    public RealtimeIOConfig getIOConfig() {
        return this.ioConfig;
    }

    @Override
    @JsonProperty(value="tuningConfig")
    public RealtimeTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public Firehose connect() throws IOException {
        return this.ioConfig.getFirehoseFactory().connect(Preconditions.checkNotNull(this.dataSchema.getParser(), "inputRowParser"), null);
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }
}

